package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "credentials", 
    "id"})
@JsonInclude(Include.NON_NULL)
public class PasswordSingleSignOnCredentialSet implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("credentials")
    protected List<Credential> credentials;

    @JsonProperty("credentials@nextLink")
    protected String credentialsNextLink;

    @JsonProperty("id")
    protected String id;

    protected PasswordSingleSignOnCredentialSet() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.passwordSingleSignOnCredentialSet";
    }

    @Property(name="credentials")
    @JsonIgnore
    public CollectionPage<Credential> getCredentials() {
        return new CollectionPage<Credential>(contextPath, Credential.class, this.credentials, Optional.ofNullable(credentialsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="credentials")
    @JsonIgnore
    public CollectionPage<Credential> getCredentials(HttpRequestOptions options) {
        return new CollectionPage<Credential>(contextPath, Credential.class, this.credentials, Optional.ofNullable(credentialsNextLink), Collections.emptyList(), options);
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public PasswordSingleSignOnCredentialSet withId(String id) {
        PasswordSingleSignOnCredentialSet _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.passwordSingleSignOnCredentialSet");
        _x.id = id;
        return _x;
    }

    public PasswordSingleSignOnCredentialSet withUnmappedField(String name, Object value) {
        PasswordSingleSignOnCredentialSet _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<Credential> credentials;
        private String credentialsNextLink;
        private String id;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder credentials(List<Credential> credentials) {
            this.credentials = credentials;
            this.changedFields = changedFields.add("credentials");
            return this;
        }

        public Builder credentials(Credential... credentials) {
            return credentials(Arrays.asList(credentials));
        }

        public Builder credentialsNextLink(String credentialsNextLink) {
            this.credentialsNextLink = credentialsNextLink;
            this.changedFields = changedFields.add("credentials");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public PasswordSingleSignOnCredentialSet build() {
            PasswordSingleSignOnCredentialSet _x = new PasswordSingleSignOnCredentialSet();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.passwordSingleSignOnCredentialSet";
            _x.credentials = credentials;
            _x.credentialsNextLink = credentialsNextLink;
            _x.id = id;
            return _x;
        }
    }

    private PasswordSingleSignOnCredentialSet _copy() {
        PasswordSingleSignOnCredentialSet _x = new PasswordSingleSignOnCredentialSet();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.credentials = credentials;
        _x.id = id;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PasswordSingleSignOnCredentialSet[");
        b.append("credentials=");
        b.append(this.credentials);
        b.append(", ");
        b.append("id=");
        b.append(this.id);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
