package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "color", 
    "description", 
    "id", 
    "isActive", 
    "name", 
    "parent", 
    "sensitivity", 
    "tooltip"})
@JsonInclude(Include.NON_NULL)
public class ParentLabelDetails implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("color")
    protected String color;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("isActive")
    protected Boolean isActive;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("parent")
    protected ParentLabelDetails parent;

    @JsonProperty("sensitivity")
    protected Integer sensitivity;

    @JsonProperty("tooltip")
    protected String tooltip;

    protected ParentLabelDetails() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.parentLabelDetails";
    }

    @Property(name="color")
    @JsonIgnore
    public Optional<String> getColor() {
        return Optional.ofNullable(color);
    }

    public ParentLabelDetails withColor(String color) {
        ParentLabelDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.parentLabelDetails");
        _x.color = color;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public ParentLabelDetails withDescription(String description) {
        ParentLabelDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.parentLabelDetails");
        _x.description = description;
        return _x;
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public ParentLabelDetails withId(String id) {
        ParentLabelDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.parentLabelDetails");
        _x.id = id;
        return _x;
    }

    @Property(name="isActive")
    @JsonIgnore
    public Optional<Boolean> getIsActive() {
        return Optional.ofNullable(isActive);
    }

    public ParentLabelDetails withIsActive(Boolean isActive) {
        ParentLabelDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.parentLabelDetails");
        _x.isActive = isActive;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public ParentLabelDetails withName(String name) {
        ParentLabelDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.parentLabelDetails");
        _x.name = name;
        return _x;
    }

    @Property(name="parent")
    @JsonIgnore
    public Optional<ParentLabelDetails> getParent() {
        return Optional.ofNullable(parent);
    }

    public ParentLabelDetails withParent(ParentLabelDetails parent) {
        ParentLabelDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.parentLabelDetails");
        _x.parent = parent;
        return _x;
    }

    @Property(name="sensitivity")
    @JsonIgnore
    public Optional<Integer> getSensitivity() {
        return Optional.ofNullable(sensitivity);
    }

    public ParentLabelDetails withSensitivity(Integer sensitivity) {
        ParentLabelDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.parentLabelDetails");
        _x.sensitivity = sensitivity;
        return _x;
    }

    @Property(name="tooltip")
    @JsonIgnore
    public Optional<String> getTooltip() {
        return Optional.ofNullable(tooltip);
    }

    public ParentLabelDetails withTooltip(String tooltip) {
        ParentLabelDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.parentLabelDetails");
        _x.tooltip = tooltip;
        return _x;
    }

    public ParentLabelDetails withUnmappedField(String name, Object value) {
        ParentLabelDetails _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String color;
        private String description;
        private String id;
        private Boolean isActive;
        private String name;
        private ParentLabelDetails parent;
        private Integer sensitivity;
        private String tooltip;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder color(String color) {
            this.color = color;
            this.changedFields = changedFields.add("color");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            this.changedFields = changedFields.add("isActive");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder parent(ParentLabelDetails parent) {
            this.parent = parent;
            this.changedFields = changedFields.add("parent");
            return this;
        }

        public Builder sensitivity(Integer sensitivity) {
            this.sensitivity = sensitivity;
            this.changedFields = changedFields.add("sensitivity");
            return this;
        }

        public Builder tooltip(String tooltip) {
            this.tooltip = tooltip;
            this.changedFields = changedFields.add("tooltip");
            return this;
        }

        public ParentLabelDetails build() {
            ParentLabelDetails _x = new ParentLabelDetails();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.parentLabelDetails";
            _x.color = color;
            _x.description = description;
            _x.id = id;
            _x.isActive = isActive;
            _x.name = name;
            _x.parent = parent;
            _x.sensitivity = sensitivity;
            _x.tooltip = tooltip;
            return _x;
        }
    }

    private ParentLabelDetails _copy() {
        ParentLabelDetails _x = new ParentLabelDetails();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.color = color;
        _x.description = description;
        _x.id = id;
        _x.isActive = isActive;
        _x.name = name;
        _x.parent = parent;
        _x.sensitivity = sensitivity;
        _x.tooltip = tooltip;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ParentLabelDetails[");
        b.append("color=");
        b.append(this.color);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("isActive=");
        b.append(this.isActive);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("parent=");
        b.append(this.parent);
        b.append(", ");
        b.append("sensitivity=");
        b.append(this.sensitivity);
        b.append(", ");
        b.append("tooltip=");
        b.append(this.tooltip);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
