package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "additionalProperties", 
    "essential", 
    "name", 
    "source"})
@JsonInclude(Include.NON_NULL)
public class OptionalClaim implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("additionalProperties")
    protected List<String> additionalProperties;

    @JsonProperty("additionalProperties@nextLink")
    protected String additionalPropertiesNextLink;

    @JsonProperty("essential")
    protected Boolean essential;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("source")
    protected String source;

    protected OptionalClaim() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.optionalClaim";
    }

    @Property(name="additionalProperties")
    @JsonIgnore
    public CollectionPage<String> getAdditionalProperties() {
        return new CollectionPage<String>(contextPath, String.class, this.additionalProperties, Optional.ofNullable(additionalPropertiesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="additionalProperties")
    @JsonIgnore
    public CollectionPage<String> getAdditionalProperties(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.additionalProperties, Optional.ofNullable(additionalPropertiesNextLink), Collections.emptyList(), options);
    }

    @Property(name="essential")
    @JsonIgnore
    public Optional<Boolean> getEssential() {
        return Optional.ofNullable(essential);
    }

    public OptionalClaim withEssential(Boolean essential) {
        OptionalClaim _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.optionalClaim");
        _x.essential = essential;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public OptionalClaim withName(String name) {
        OptionalClaim _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.optionalClaim");
        _x.name = name;
        return _x;
    }

    @Property(name="source")
    @JsonIgnore
    public Optional<String> getSource() {
        return Optional.ofNullable(source);
    }

    public OptionalClaim withSource(String source) {
        OptionalClaim _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.optionalClaim");
        _x.source = source;
        return _x;
    }

    public OptionalClaim withUnmappedField(String name, Object value) {
        OptionalClaim _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> additionalProperties;
        private String additionalPropertiesNextLink;
        private Boolean essential;
        private String name;
        private String source;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder additionalProperties(List<String> additionalProperties) {
            this.additionalProperties = additionalProperties;
            this.changedFields = changedFields.add("additionalProperties");
            return this;
        }

        public Builder additionalProperties(String... additionalProperties) {
            return additionalProperties(Arrays.asList(additionalProperties));
        }

        public Builder additionalPropertiesNextLink(String additionalPropertiesNextLink) {
            this.additionalPropertiesNextLink = additionalPropertiesNextLink;
            this.changedFields = changedFields.add("additionalProperties");
            return this;
        }

        public Builder essential(Boolean essential) {
            this.essential = essential;
            this.changedFields = changedFields.add("essential");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            this.changedFields = changedFields.add("source");
            return this;
        }

        public OptionalClaim build() {
            OptionalClaim _x = new OptionalClaim();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.optionalClaim";
            _x.additionalProperties = additionalProperties;
            _x.additionalPropertiesNextLink = additionalPropertiesNextLink;
            _x.essential = essential;
            _x.name = name;
            _x.source = source;
            return _x;
        }
    }

    private OptionalClaim _copy() {
        OptionalClaim _x = new OptionalClaim();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.additionalProperties = additionalProperties;
        _x.essential = essential;
        _x.name = name;
        _x.source = source;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OptionalClaim[");
        b.append("additionalProperties=");
        b.append(this.additionalProperties);
        b.append(", ");
        b.append("essential=");
        b.append(this.essential);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("source=");
        b.append(this.source);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
