package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "conferenceId", 
    "joinUrl", 
    "phones", 
    "quickDial", 
    "tollFreeNumbers", 
    "tollNumber"})
@JsonInclude(Include.NON_NULL)
public class OnlineMeetingInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("conferenceId")
    protected String conferenceId;

    @JsonProperty("joinUrl")
    protected String joinUrl;

    @JsonProperty("phones")
    protected List<Phone> phones;

    @JsonProperty("phones@nextLink")
    protected String phonesNextLink;

    @JsonProperty("quickDial")
    protected String quickDial;

    @JsonProperty("tollFreeNumbers")
    protected List<String> tollFreeNumbers;

    @JsonProperty("tollFreeNumbers@nextLink")
    protected String tollFreeNumbersNextLink;

    @JsonProperty("tollNumber")
    protected String tollNumber;

    protected OnlineMeetingInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.onlineMeetingInfo";
    }

    @Property(name="conferenceId")
    @JsonIgnore
    public Optional<String> getConferenceId() {
        return Optional.ofNullable(conferenceId);
    }

    public OnlineMeetingInfo withConferenceId(String conferenceId) {
        OnlineMeetingInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeetingInfo");
        _x.conferenceId = conferenceId;
        return _x;
    }

    @Property(name="joinUrl")
    @JsonIgnore
    public Optional<String> getJoinUrl() {
        return Optional.ofNullable(joinUrl);
    }

    public OnlineMeetingInfo withJoinUrl(String joinUrl) {
        OnlineMeetingInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeetingInfo");
        _x.joinUrl = joinUrl;
        return _x;
    }

    @Property(name="phones")
    @JsonIgnore
    public CollectionPage<Phone> getPhones() {
        return new CollectionPage<Phone>(contextPath, Phone.class, this.phones, Optional.ofNullable(phonesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="phones")
    @JsonIgnore
    public CollectionPage<Phone> getPhones(HttpRequestOptions options) {
        return new CollectionPage<Phone>(contextPath, Phone.class, this.phones, Optional.ofNullable(phonesNextLink), Collections.emptyList(), options);
    }

    @Property(name="quickDial")
    @JsonIgnore
    public Optional<String> getQuickDial() {
        return Optional.ofNullable(quickDial);
    }

    public OnlineMeetingInfo withQuickDial(String quickDial) {
        OnlineMeetingInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeetingInfo");
        _x.quickDial = quickDial;
        return _x;
    }

    @Property(name="tollFreeNumbers")
    @JsonIgnore
    public CollectionPage<String> getTollFreeNumbers() {
        return new CollectionPage<String>(contextPath, String.class, this.tollFreeNumbers, Optional.ofNullable(tollFreeNumbersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="tollFreeNumbers")
    @JsonIgnore
    public CollectionPage<String> getTollFreeNumbers(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.tollFreeNumbers, Optional.ofNullable(tollFreeNumbersNextLink), Collections.emptyList(), options);
    }

    @Property(name="tollNumber")
    @JsonIgnore
    public Optional<String> getTollNumber() {
        return Optional.ofNullable(tollNumber);
    }

    public OnlineMeetingInfo withTollNumber(String tollNumber) {
        OnlineMeetingInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onlineMeetingInfo");
        _x.tollNumber = tollNumber;
        return _x;
    }

    public OnlineMeetingInfo withUnmappedField(String name, Object value) {
        OnlineMeetingInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String conferenceId;
        private String joinUrl;
        private List<Phone> phones;
        private String phonesNextLink;
        private String quickDial;
        private List<String> tollFreeNumbers;
        private String tollFreeNumbersNextLink;
        private String tollNumber;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder conferenceId(String conferenceId) {
            this.conferenceId = conferenceId;
            this.changedFields = changedFields.add("conferenceId");
            return this;
        }

        public Builder joinUrl(String joinUrl) {
            this.joinUrl = joinUrl;
            this.changedFields = changedFields.add("joinUrl");
            return this;
        }

        public Builder phones(List<Phone> phones) {
            this.phones = phones;
            this.changedFields = changedFields.add("phones");
            return this;
        }

        public Builder phones(Phone... phones) {
            return phones(Arrays.asList(phones));
        }

        public Builder phonesNextLink(String phonesNextLink) {
            this.phonesNextLink = phonesNextLink;
            this.changedFields = changedFields.add("phones");
            return this;
        }

        public Builder quickDial(String quickDial) {
            this.quickDial = quickDial;
            this.changedFields = changedFields.add("quickDial");
            return this;
        }

        public Builder tollFreeNumbers(List<String> tollFreeNumbers) {
            this.tollFreeNumbers = tollFreeNumbers;
            this.changedFields = changedFields.add("tollFreeNumbers");
            return this;
        }

        public Builder tollFreeNumbers(String... tollFreeNumbers) {
            return tollFreeNumbers(Arrays.asList(tollFreeNumbers));
        }

        public Builder tollFreeNumbersNextLink(String tollFreeNumbersNextLink) {
            this.tollFreeNumbersNextLink = tollFreeNumbersNextLink;
            this.changedFields = changedFields.add("tollFreeNumbers");
            return this;
        }

        public Builder tollNumber(String tollNumber) {
            this.tollNumber = tollNumber;
            this.changedFields = changedFields.add("tollNumber");
            return this;
        }

        public OnlineMeetingInfo build() {
            OnlineMeetingInfo _x = new OnlineMeetingInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.onlineMeetingInfo";
            _x.conferenceId = conferenceId;
            _x.joinUrl = joinUrl;
            _x.phones = phones;
            _x.phonesNextLink = phonesNextLink;
            _x.quickDial = quickDial;
            _x.tollFreeNumbers = tollFreeNumbers;
            _x.tollFreeNumbersNextLink = tollFreeNumbersNextLink;
            _x.tollNumber = tollNumber;
            return _x;
        }
    }

    private OnlineMeetingInfo _copy() {
        OnlineMeetingInfo _x = new OnlineMeetingInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.conferenceId = conferenceId;
        _x.joinUrl = joinUrl;
        _x.phones = phones;
        _x.quickDial = quickDial;
        _x.tollFreeNumbers = tollFreeNumbers;
        _x.tollNumber = tollNumber;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OnlineMeetingInfo[");
        b.append("conferenceId=");
        b.append(this.conferenceId);
        b.append(", ");
        b.append("joinUrl=");
        b.append(this.joinUrl);
        b.append(", ");
        b.append("phones=");
        b.append(this.phones);
        b.append(", ");
        b.append("quickDial=");
        b.append(this.quickDial);
        b.append(", ");
        b.append("tollFreeNumbers=");
        b.append(this.tollFreeNumbers);
        b.append(", ");
        b.append("tollNumber=");
        b.append(this.tollNumber);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
