package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.SingleSignOnMode;

@JsonPropertyOrder({
    "@odata.type", 
    "kerberosSignOnSettings", 
    "singleSignOnMode"})
@JsonInclude(Include.NON_NULL)
public class OnPremisesPublishingSingleSignOn implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("kerberosSignOnSettings")
    protected KerberosSignOnSettings kerberosSignOnSettings;

    @JsonProperty("singleSignOnMode")
    protected SingleSignOnMode singleSignOnMode;

    protected OnPremisesPublishingSingleSignOn() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.onPremisesPublishingSingleSignOn";
    }

    @Property(name="kerberosSignOnSettings")
    @JsonIgnore
    public Optional<KerberosSignOnSettings> getKerberosSignOnSettings() {
        return Optional.ofNullable(kerberosSignOnSettings);
    }

    public OnPremisesPublishingSingleSignOn withKerberosSignOnSettings(KerberosSignOnSettings kerberosSignOnSettings) {
        OnPremisesPublishingSingleSignOn _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesPublishingSingleSignOn");
        _x.kerberosSignOnSettings = kerberosSignOnSettings;
        return _x;
    }

    @Property(name="singleSignOnMode")
    @JsonIgnore
    public Optional<SingleSignOnMode> getSingleSignOnMode() {
        return Optional.ofNullable(singleSignOnMode);
    }

    public OnPremisesPublishingSingleSignOn withSingleSignOnMode(SingleSignOnMode singleSignOnMode) {
        OnPremisesPublishingSingleSignOn _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.onPremisesPublishingSingleSignOn");
        _x.singleSignOnMode = singleSignOnMode;
        return _x;
    }

    public OnPremisesPublishingSingleSignOn withUnmappedField(String name, Object value) {
        OnPremisesPublishingSingleSignOn _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private KerberosSignOnSettings kerberosSignOnSettings;
        private SingleSignOnMode singleSignOnMode;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder kerberosSignOnSettings(KerberosSignOnSettings kerberosSignOnSettings) {
            this.kerberosSignOnSettings = kerberosSignOnSettings;
            this.changedFields = changedFields.add("kerberosSignOnSettings");
            return this;
        }

        public Builder singleSignOnMode(SingleSignOnMode singleSignOnMode) {
            this.singleSignOnMode = singleSignOnMode;
            this.changedFields = changedFields.add("singleSignOnMode");
            return this;
        }

        public OnPremisesPublishingSingleSignOn build() {
            OnPremisesPublishingSingleSignOn _x = new OnPremisesPublishingSingleSignOn();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.onPremisesPublishingSingleSignOn";
            _x.kerberosSignOnSettings = kerberosSignOnSettings;
            _x.singleSignOnMode = singleSignOnMode;
            return _x;
        }
    }

    private OnPremisesPublishingSingleSignOn _copy() {
        OnPremisesPublishingSingleSignOn _x = new OnPremisesPublishingSingleSignOn();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.kerberosSignOnSettings = kerberosSignOnSettings;
        _x.singleSignOnMode = singleSignOnMode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OnPremisesPublishingSingleSignOn[");
        b.append("kerberosSignOnSettings=");
        b.append(this.kerberosSignOnSettings);
        b.append(", ");
        b.append("singleSignOnMode=");
        b.append(this.singleSignOnMode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
