package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“OMA Settings Boolean definition.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "value"})
@JsonInclude(Include.NON_NULL)
public class OmaSettingBoolean extends OmaSetting implements ODataType {

    @JsonProperty("value")
    protected Boolean value;

    protected OmaSettingBoolean() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.omaSettingBoolean";
    }

    /**
     * <i>“Value.”</i>
     * 
     * @return property value
     */
    @Property(name="value")
    @JsonIgnore
    public Optional<Boolean> getValue() {
        return Optional.ofNullable(value);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code value} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Value.”</i>
     * 
     * @param value
     *            new value of {@code value} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code value} field changed
     */
    public OmaSettingBoolean withValue(Boolean value) {
        OmaSettingBoolean _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.omaSettingBoolean");
        _x.value = value;
        return _x;
    }

    public OmaSettingBoolean withUnmappedField(String name, Object value) {
        OmaSettingBoolean _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOmaSettingBoolean() {
        return new Builder();
    }

    public static final class Builder {
        private String description;
        private String displayName;
        private Boolean isEncrypted;
        private String omaUri;
        private String secretReferenceValueId;
        private Boolean value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder isEncrypted(Boolean isEncrypted) {
            this.isEncrypted = isEncrypted;
            this.changedFields = changedFields.add("isEncrypted");
            return this;
        }

        public Builder omaUri(String omaUri) {
            this.omaUri = omaUri;
            this.changedFields = changedFields.add("omaUri");
            return this;
        }

        public Builder secretReferenceValueId(String secretReferenceValueId) {
            this.secretReferenceValueId = secretReferenceValueId;
            this.changedFields = changedFields.add("secretReferenceValueId");
            return this;
        }

        /**
         * <i>“Value.”</i>
         * 
         * @param value
         *            value of {@code value} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder value(Boolean value) {
            this.value = value;
            this.changedFields = changedFields.add("value");
            return this;
        }

        public OmaSettingBoolean build() {
            OmaSettingBoolean _x = new OmaSettingBoolean();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.omaSettingBoolean";
            _x.description = description;
            _x.displayName = displayName;
            _x.isEncrypted = isEncrypted;
            _x.omaUri = omaUri;
            _x.secretReferenceValueId = secretReferenceValueId;
            _x.value = value;
            return _x;
        }
    }

    private OmaSettingBoolean _copy() {
        OmaSettingBoolean _x = new OmaSettingBoolean();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.description = description;
        _x.displayName = displayName;
        _x.isEncrypted = isEncrypted;
        _x.omaUri = omaUri;
        _x.secretReferenceValueId = secretReferenceValueId;
        _x.value = value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OmaSettingBoolean[");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isEncrypted=");
        b.append(this.isEncrypted);
        b.append(", ");
        b.append("omaUri=");
        b.append(this.omaUri);
        b.append(", ");
        b.append("secretReferenceValueId=");
        b.append(this.secretReferenceValueId);
        b.append(", ");
        b.append("value=");
        b.append(this.value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
