package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“OMA Settings definition.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "displayName", 
    "isEncrypted", 
    "omaUri", 
    "secretReferenceValueId"})
@JsonInclude(Include.NON_NULL)
public class OmaSetting implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isEncrypted")
    protected Boolean isEncrypted;

    @JsonProperty("omaUri")
    protected String omaUri;

    @JsonProperty("secretReferenceValueId")
    protected String secretReferenceValueId;

    protected OmaSetting() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.omaSetting";
    }

    /**
     * <i>“Description.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Description.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public OmaSetting withDescription(String description) {
        OmaSetting _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.omaSetting");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“Display Name.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Display Name.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public OmaSetting withDisplayName(String displayName) {
        OmaSetting _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.omaSetting");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Indicates whether the value field is encrypted. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property isEncrypted
     */
    @Property(name="isEncrypted")
    @JsonIgnore
    public Optional<Boolean> getIsEncrypted() {
        return Optional.ofNullable(isEncrypted);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isEncrypted}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether the value field is encrypted. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param isEncrypted
     *            new value of {@code isEncrypted} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isEncrypted} field changed
     */
    public OmaSetting withIsEncrypted(Boolean isEncrypted) {
        OmaSetting _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.omaSetting");
        _x.isEncrypted = isEncrypted;
        return _x;
    }

    /**
     * <i>“OMA.”</i>
     * 
     * @return property omaUri
     */
    @Property(name="omaUri")
    @JsonIgnore
    public Optional<String> getOmaUri() {
        return Optional.ofNullable(omaUri);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code omaUri} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“OMA.”</i>
     * 
     * @param omaUri
     *            new value of {@code omaUri} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code omaUri} field changed
     */
    public OmaSetting withOmaUri(String omaUri) {
        OmaSetting _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.omaSetting");
        _x.omaUri = omaUri;
        return _x;
    }

    /**
     * <i>“ReferenceId for looking up secret for decryption. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property secretReferenceValueId
     */
    @Property(name="secretReferenceValueId")
    @JsonIgnore
    public Optional<String> getSecretReferenceValueId() {
        return Optional.ofNullable(secretReferenceValueId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * secretReferenceValueId} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“ReferenceId for looking up secret for decryption. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param secretReferenceValueId
     *            new value of {@code secretReferenceValueId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code secretReferenceValueId} field changed
     */
    public OmaSetting withSecretReferenceValueId(String secretReferenceValueId) {
        OmaSetting _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.omaSetting");
        _x.secretReferenceValueId = secretReferenceValueId;
        return _x;
    }

    public OmaSetting withUnmappedField(String name, Object value) {
        OmaSetting _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    private OmaSetting _copy() {
        OmaSetting _x = new OmaSetting();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.description = description;
        _x.displayName = displayName;
        _x.isEncrypted = isEncrypted;
        _x.omaUri = omaUri;
        _x.secretReferenceValueId = secretReferenceValueId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OmaSetting[");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isEncrypted=");
        b.append(this.isEncrypted);
        b.append(", ");
        b.append("omaUri=");
        b.append(this.omaUri);
        b.append(", ");
        b.append("secretReferenceValueId=");
        b.append(this.secretReferenceValueId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
