package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "issuer", 
    "issuerAssignedId", 
    "signInType"})
@JsonInclude(Include.NON_NULL)
public class ObjectIdentity implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("issuer")
    protected String issuer;

    @JsonProperty("issuerAssignedId")
    protected String issuerAssignedId;

    @JsonProperty("signInType")
    protected String signInType;

    protected ObjectIdentity() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.objectIdentity";
    }

    @Property(name="issuer")
    @JsonIgnore
    public Optional<String> getIssuer() {
        return Optional.ofNullable(issuer);
    }

    public ObjectIdentity withIssuer(String issuer) {
        ObjectIdentity _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.objectIdentity");
        _x.issuer = issuer;
        return _x;
    }

    @Property(name="issuerAssignedId")
    @JsonIgnore
    public Optional<String> getIssuerAssignedId() {
        return Optional.ofNullable(issuerAssignedId);
    }

    public ObjectIdentity withIssuerAssignedId(String issuerAssignedId) {
        ObjectIdentity _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.objectIdentity");
        _x.issuerAssignedId = issuerAssignedId;
        return _x;
    }

    @Property(name="signInType")
    @JsonIgnore
    public Optional<String> getSignInType() {
        return Optional.ofNullable(signInType);
    }

    public ObjectIdentity withSignInType(String signInType) {
        ObjectIdentity _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.objectIdentity");
        _x.signInType = signInType;
        return _x;
    }

    public ObjectIdentity withUnmappedField(String name, Object value) {
        ObjectIdentity _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String issuer;
        private String issuerAssignedId;
        private String signInType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder issuer(String issuer) {
            this.issuer = issuer;
            this.changedFields = changedFields.add("issuer");
            return this;
        }

        public Builder issuerAssignedId(String issuerAssignedId) {
            this.issuerAssignedId = issuerAssignedId;
            this.changedFields = changedFields.add("issuerAssignedId");
            return this;
        }

        public Builder signInType(String signInType) {
            this.signInType = signInType;
            this.changedFields = changedFields.add("signInType");
            return this;
        }

        public ObjectIdentity build() {
            ObjectIdentity _x = new ObjectIdentity();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.objectIdentity";
            _x.issuer = issuer;
            _x.issuerAssignedId = issuerAssignedId;
            _x.signInType = signInType;
            return _x;
        }
    }

    private ObjectIdentity _copy() {
        ObjectIdentity _x = new ObjectIdentity();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.issuer = issuer;
        _x.issuerAssignedId = issuerAssignedId;
        _x.signInType = signInType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ObjectIdentity[");
        b.append("issuer=");
        b.append(this.issuer);
        b.append(", ");
        b.append("issuerAssignedId=");
        b.append(this.issuerAssignedId);
        b.append(", ");
        b.append("signInType=");
        b.append(this.signInType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
