package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "enabled", 
    "manufacturer", 
    "manufacturerProperties", 
    "serialNumber", 
    "tokenType"})
@JsonInclude(Include.NON_NULL)
public class OathTokenMetadata implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("enabled")
    protected Boolean enabled;

    @JsonProperty("manufacturer")
    protected String manufacturer;

    @JsonProperty("manufacturerProperties")
    protected List<KeyValue> manufacturerProperties;

    @JsonProperty("manufacturerProperties@nextLink")
    protected String manufacturerPropertiesNextLink;

    @JsonProperty("serialNumber")
    protected String serialNumber;

    @JsonProperty("tokenType")
    protected String tokenType;

    protected OathTokenMetadata() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.oathTokenMetadata";
    }

    @Property(name="enabled")
    @JsonIgnore
    public Optional<Boolean> getEnabled() {
        return Optional.ofNullable(enabled);
    }

    public OathTokenMetadata withEnabled(Boolean enabled) {
        OathTokenMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.oathTokenMetadata");
        _x.enabled = enabled;
        return _x;
    }

    @Property(name="manufacturer")
    @JsonIgnore
    public Optional<String> getManufacturer() {
        return Optional.ofNullable(manufacturer);
    }

    public OathTokenMetadata withManufacturer(String manufacturer) {
        OathTokenMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.oathTokenMetadata");
        _x.manufacturer = manufacturer;
        return _x;
    }

    @Property(name="manufacturerProperties")
    @JsonIgnore
    public CollectionPage<KeyValue> getManufacturerProperties() {
        return new CollectionPage<KeyValue>(contextPath, KeyValue.class, this.manufacturerProperties, Optional.ofNullable(manufacturerPropertiesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="manufacturerProperties")
    @JsonIgnore
    public CollectionPage<KeyValue> getManufacturerProperties(HttpRequestOptions options) {
        return new CollectionPage<KeyValue>(contextPath, KeyValue.class, this.manufacturerProperties, Optional.ofNullable(manufacturerPropertiesNextLink), Collections.emptyList(), options);
    }

    @Property(name="serialNumber")
    @JsonIgnore
    public Optional<String> getSerialNumber() {
        return Optional.ofNullable(serialNumber);
    }

    public OathTokenMetadata withSerialNumber(String serialNumber) {
        OathTokenMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.oathTokenMetadata");
        _x.serialNumber = serialNumber;
        return _x;
    }

    @Property(name="tokenType")
    @JsonIgnore
    public Optional<String> getTokenType() {
        return Optional.ofNullable(tokenType);
    }

    public OathTokenMetadata withTokenType(String tokenType) {
        OathTokenMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.oathTokenMetadata");
        _x.tokenType = tokenType;
        return _x;
    }

    public OathTokenMetadata withUnmappedField(String name, Object value) {
        OathTokenMetadata _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean enabled;
        private String manufacturer;
        private List<KeyValue> manufacturerProperties;
        private String manufacturerPropertiesNextLink;
        private String serialNumber;
        private String tokenType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            this.changedFields = changedFields.add("enabled");
            return this;
        }

        public Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            this.changedFields = changedFields.add("manufacturer");
            return this;
        }

        public Builder manufacturerProperties(List<KeyValue> manufacturerProperties) {
            this.manufacturerProperties = manufacturerProperties;
            this.changedFields = changedFields.add("manufacturerProperties");
            return this;
        }

        public Builder manufacturerProperties(KeyValue... manufacturerProperties) {
            return manufacturerProperties(Arrays.asList(manufacturerProperties));
        }

        public Builder manufacturerPropertiesNextLink(String manufacturerPropertiesNextLink) {
            this.manufacturerPropertiesNextLink = manufacturerPropertiesNextLink;
            this.changedFields = changedFields.add("manufacturerProperties");
            return this;
        }

        public Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            this.changedFields = changedFields.add("serialNumber");
            return this;
        }

        public Builder tokenType(String tokenType) {
            this.tokenType = tokenType;
            this.changedFields = changedFields.add("tokenType");
            return this;
        }

        public OathTokenMetadata build() {
            OathTokenMetadata _x = new OathTokenMetadata();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.oathTokenMetadata";
            _x.enabled = enabled;
            _x.manufacturer = manufacturer;
            _x.manufacturerProperties = manufacturerProperties;
            _x.manufacturerPropertiesNextLink = manufacturerPropertiesNextLink;
            _x.serialNumber = serialNumber;
            _x.tokenType = tokenType;
            return _x;
        }
    }

    private OathTokenMetadata _copy() {
        OathTokenMetadata _x = new OathTokenMetadata();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.enabled = enabled;
        _x.manufacturer = manufacturer;
        _x.manufacturerProperties = manufacturerProperties;
        _x.serialNumber = serialNumber;
        _x.tokenType = tokenType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OathTokenMetadata[");
        b.append("enabled=");
        b.append(this.enabled);
        b.append(", ");
        b.append("manufacturer=");
        b.append(this.manufacturer);
        b.append(", ");
        b.append("manufacturerProperties=");
        b.append(this.manufacturerProperties);
        b.append(", ");
        b.append("serialNumber=");
        b.append(this.serialNumber);
        b.append(", ");
        b.append("tokenType=");
        b.append(this.tokenType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
