package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "oneNoteClientUrl", 
    "oneNoteWebUrl"})
@JsonInclude(Include.NON_NULL)
public class NotebookLinks implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("oneNoteClientUrl")
    protected ExternalLink oneNoteClientUrl;

    @JsonProperty("oneNoteWebUrl")
    protected ExternalLink oneNoteWebUrl;

    protected NotebookLinks() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.notebookLinks";
    }

    @Property(name="oneNoteClientUrl")
    @JsonIgnore
    public Optional<ExternalLink> getOneNoteClientUrl() {
        return Optional.ofNullable(oneNoteClientUrl);
    }

    public NotebookLinks withOneNoteClientUrl(ExternalLink oneNoteClientUrl) {
        NotebookLinks _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.notebookLinks");
        _x.oneNoteClientUrl = oneNoteClientUrl;
        return _x;
    }

    @Property(name="oneNoteWebUrl")
    @JsonIgnore
    public Optional<ExternalLink> getOneNoteWebUrl() {
        return Optional.ofNullable(oneNoteWebUrl);
    }

    public NotebookLinks withOneNoteWebUrl(ExternalLink oneNoteWebUrl) {
        NotebookLinks _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.notebookLinks");
        _x.oneNoteWebUrl = oneNoteWebUrl;
        return _x;
    }

    public NotebookLinks withUnmappedField(String name, Object value) {
        NotebookLinks _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ExternalLink oneNoteClientUrl;
        private ExternalLink oneNoteWebUrl;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder oneNoteClientUrl(ExternalLink oneNoteClientUrl) {
            this.oneNoteClientUrl = oneNoteClientUrl;
            this.changedFields = changedFields.add("oneNoteClientUrl");
            return this;
        }

        public Builder oneNoteWebUrl(ExternalLink oneNoteWebUrl) {
            this.oneNoteWebUrl = oneNoteWebUrl;
            this.changedFields = changedFields.add("oneNoteWebUrl");
            return this;
        }

        public NotebookLinks build() {
            NotebookLinks _x = new NotebookLinks();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.notebookLinks";
            _x.oneNoteClientUrl = oneNoteClientUrl;
            _x.oneNoteWebUrl = oneNoteWebUrl;
            return _x;
        }
    }

    private NotebookLinks _copy() {
        NotebookLinks _x = new NotebookLinks();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.oneNoteClientUrl = oneNoteClientUrl;
        _x.oneNoteWebUrl = oneNoteWebUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("NotebookLinks[");
        b.append("oneNoteClientUrl=");
        b.append(this.oneNoteClientUrl);
        b.append(", ");
        b.append("oneNoteWebUrl=");
        b.append(this.oneNoteWebUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
