package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DeviceType;


/**
 * <i>“Device properties”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "maximumOperatingSystemVersion", 
    "minimumOperatingSystemVersion", 
    "type"})
@JsonInclude(Include.NON_NULL)
public class MobileAppSupportedDeviceType implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("maximumOperatingSystemVersion")
    protected String maximumOperatingSystemVersion;

    @JsonProperty("minimumOperatingSystemVersion")
    protected String minimumOperatingSystemVersion;

    @JsonProperty("type")
    protected DeviceType type;

    protected MobileAppSupportedDeviceType() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mobileAppSupportedDeviceType";
    }

    /**
     * <i>“Maximum OS version”</i>
     * 
     * @return property maximumOperatingSystemVersion
     */
    @Property(name="maximumOperatingSystemVersion")
    @JsonIgnore
    public Optional<String> getMaximumOperatingSystemVersion() {
        return Optional.ofNullable(maximumOperatingSystemVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * maximumOperatingSystemVersion} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Maximum OS version”</i>
     * 
     * @param maximumOperatingSystemVersion
     *            new value of {@code maximumOperatingSystemVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code maximumOperatingSystemVersion} field changed
     */
    public MobileAppSupportedDeviceType withMaximumOperatingSystemVersion(String maximumOperatingSystemVersion) {
        MobileAppSupportedDeviceType _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppSupportedDeviceType");
        _x.maximumOperatingSystemVersion = maximumOperatingSystemVersion;
        return _x;
    }

    /**
     * <i>“Minimum OS version”</i>
     * 
     * @return property minimumOperatingSystemVersion
     */
    @Property(name="minimumOperatingSystemVersion")
    @JsonIgnore
    public Optional<String> getMinimumOperatingSystemVersion() {
        return Optional.ofNullable(minimumOperatingSystemVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumOperatingSystemVersion} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Minimum OS version”</i>
     * 
     * @param minimumOperatingSystemVersion
     *            new value of {@code minimumOperatingSystemVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumOperatingSystemVersion} field changed
     */
    public MobileAppSupportedDeviceType withMinimumOperatingSystemVersion(String minimumOperatingSystemVersion) {
        MobileAppSupportedDeviceType _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppSupportedDeviceType");
        _x.minimumOperatingSystemVersion = minimumOperatingSystemVersion;
        return _x;
    }

    /**
     * <i>“Device type”</i>
     * 
     * @return property type
     */
    @Property(name="type")
    @JsonIgnore
    public Optional<DeviceType> getType() {
        return Optional.ofNullable(type);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code type} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Device type”</i>
     * 
     * @param type
     *            new value of {@code type} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code type} field changed
     */
    public MobileAppSupportedDeviceType withType(DeviceType type) {
        MobileAppSupportedDeviceType _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppSupportedDeviceType");
        _x.type = type;
        return _x;
    }

    public MobileAppSupportedDeviceType withUnmappedField(String name, Object value) {
        MobileAppSupportedDeviceType _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String maximumOperatingSystemVersion;
        private String minimumOperatingSystemVersion;
        private DeviceType type;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Maximum OS version”</i>
         * 
         * @param maximumOperatingSystemVersion
         *            value of {@code maximumOperatingSystemVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder maximumOperatingSystemVersion(String maximumOperatingSystemVersion) {
            this.maximumOperatingSystemVersion = maximumOperatingSystemVersion;
            this.changedFields = changedFields.add("maximumOperatingSystemVersion");
            return this;
        }

        /**
         * <i>“Minimum OS version”</i>
         * 
         * @param minimumOperatingSystemVersion
         *            value of {@code minimumOperatingSystemVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumOperatingSystemVersion(String minimumOperatingSystemVersion) {
            this.minimumOperatingSystemVersion = minimumOperatingSystemVersion;
            this.changedFields = changedFields.add("minimumOperatingSystemVersion");
            return this;
        }

        /**
         * <i>“Device type”</i>
         * 
         * @param type
         *            value of {@code type} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder type(DeviceType type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public MobileAppSupportedDeviceType build() {
            MobileAppSupportedDeviceType _x = new MobileAppSupportedDeviceType();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.mobileAppSupportedDeviceType";
            _x.maximumOperatingSystemVersion = maximumOperatingSystemVersion;
            _x.minimumOperatingSystemVersion = minimumOperatingSystemVersion;
            _x.type = type;
            return _x;
        }
    }

    private MobileAppSupportedDeviceType _copy() {
        MobileAppSupportedDeviceType _x = new MobileAppSupportedDeviceType();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.maximumOperatingSystemVersion = maximumOperatingSystemVersion;
        _x.minimumOperatingSystemVersion = minimumOperatingSystemVersion;
        _x.type = type;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MobileAppSupportedDeviceType[");
        b.append("maximumOperatingSystemVersion=");
        b.append(this.maximumOperatingSystemVersion);
        b.append(", ");
        b.append("minimumOperatingSystemVersion=");
        b.append(this.minimumOperatingSystemVersion);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
