package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <i>“Metric Time series data point”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "dateTime", 
    "value"})
@JsonInclude(Include.NON_NULL)
public class MetricTimeSeriesDataPoint implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("dateTime")
    protected OffsetDateTime dateTime;

    @JsonProperty("value")
    protected Long value;

    protected MetricTimeSeriesDataPoint() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.metricTimeSeriesDataPoint";
    }

    /**
     * <i>“Time of the metric time series data point”</i>
     * 
     * @return property dateTime
     */
    @Property(name="dateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getDateTime() {
        return Optional.ofNullable(dateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code dateTime} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Time of the metric time series data point”</i>
     * 
     * @param dateTime
     *            new value of {@code dateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dateTime} field changed
     */
    public MetricTimeSeriesDataPoint withDateTime(OffsetDateTime dateTime) {
        MetricTimeSeriesDataPoint _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.metricTimeSeriesDataPoint");
        _x.dateTime = dateTime;
        return _x;
    }

    /**
     * <i>“Value of the metric time series data point”</i>
     * 
     * @return property value
     */
    @Property(name="value")
    @JsonIgnore
    public Optional<Long> getValue() {
        return Optional.ofNullable(value);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code value} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Value of the metric time series data point”</i>
     * 
     * @param value
     *            new value of {@code value} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code value} field changed
     */
    public MetricTimeSeriesDataPoint withValue(Long value) {
        MetricTimeSeriesDataPoint _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.metricTimeSeriesDataPoint");
        _x.value = value;
        return _x;
    }

    public MetricTimeSeriesDataPoint withUnmappedField(String name, Object value) {
        MetricTimeSeriesDataPoint _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime dateTime;
        private Long value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Time of the metric time series data point”</i>
         * 
         * @param dateTime
         *            value of {@code dateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dateTime(OffsetDateTime dateTime) {
            this.dateTime = dateTime;
            this.changedFields = changedFields.add("dateTime");
            return this;
        }

        /**
         * <i>“Value of the metric time series data point”</i>
         * 
         * @param value
         *            value of {@code value} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder value(Long value) {
            this.value = value;
            this.changedFields = changedFields.add("value");
            return this;
        }

        public MetricTimeSeriesDataPoint build() {
            MetricTimeSeriesDataPoint _x = new MetricTimeSeriesDataPoint();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.metricTimeSeriesDataPoint";
            _x.dateTime = dateTime;
            _x.value = value;
            return _x;
        }
    }

    private MetricTimeSeriesDataPoint _copy() {
        MetricTimeSeriesDataPoint _x = new MetricTimeSeriesDataPoint();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.dateTime = dateTime;
        _x.value = value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MetricTimeSeriesDataPoint[");
        b.append("dateTime=");
        b.append(this.dateTime);
        b.append(", ");
        b.append("value=");
        b.append(this.value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
