package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "connectingIP", 
    "deliveryAction", 
    "deliveryLocation", 
    "directionality", 
    "internetMessageId", 
    "messageFingerprint", 
    "messageReceivedDateTime", 
    "messageSubject", 
    "networkMessageId"})
@JsonInclude(Include.NON_NULL)
public class MessageSecurityState implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("connectingIP")
    protected String connectingIP;

    @JsonProperty("deliveryAction")
    protected String deliveryAction;

    @JsonProperty("deliveryLocation")
    protected String deliveryLocation;

    @JsonProperty("directionality")
    protected String directionality;

    @JsonProperty("internetMessageId")
    protected String internetMessageId;

    @JsonProperty("messageFingerprint")
    protected String messageFingerprint;

    @JsonProperty("messageReceivedDateTime")
    protected OffsetDateTime messageReceivedDateTime;

    @JsonProperty("messageSubject")
    protected String messageSubject;

    @JsonProperty("networkMessageId")
    protected String networkMessageId;

    protected MessageSecurityState() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.messageSecurityState";
    }

    @Property(name="connectingIP")
    @JsonIgnore
    public Optional<String> getConnectingIP() {
        return Optional.ofNullable(connectingIP);
    }

    public MessageSecurityState withConnectingIP(String connectingIP) {
        MessageSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageSecurityState");
        _x.connectingIP = connectingIP;
        return _x;
    }

    @Property(name="deliveryAction")
    @JsonIgnore
    public Optional<String> getDeliveryAction() {
        return Optional.ofNullable(deliveryAction);
    }

    public MessageSecurityState withDeliveryAction(String deliveryAction) {
        MessageSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageSecurityState");
        _x.deliveryAction = deliveryAction;
        return _x;
    }

    @Property(name="deliveryLocation")
    @JsonIgnore
    public Optional<String> getDeliveryLocation() {
        return Optional.ofNullable(deliveryLocation);
    }

    public MessageSecurityState withDeliveryLocation(String deliveryLocation) {
        MessageSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageSecurityState");
        _x.deliveryLocation = deliveryLocation;
        return _x;
    }

    @Property(name="directionality")
    @JsonIgnore
    public Optional<String> getDirectionality() {
        return Optional.ofNullable(directionality);
    }

    public MessageSecurityState withDirectionality(String directionality) {
        MessageSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageSecurityState");
        _x.directionality = directionality;
        return _x;
    }

    @Property(name="internetMessageId")
    @JsonIgnore
    public Optional<String> getInternetMessageId() {
        return Optional.ofNullable(internetMessageId);
    }

    public MessageSecurityState withInternetMessageId(String internetMessageId) {
        MessageSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageSecurityState");
        _x.internetMessageId = internetMessageId;
        return _x;
    }

    @Property(name="messageFingerprint")
    @JsonIgnore
    public Optional<String> getMessageFingerprint() {
        return Optional.ofNullable(messageFingerprint);
    }

    public MessageSecurityState withMessageFingerprint(String messageFingerprint) {
        MessageSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageSecurityState");
        _x.messageFingerprint = messageFingerprint;
        return _x;
    }

    @Property(name="messageReceivedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getMessageReceivedDateTime() {
        return Optional.ofNullable(messageReceivedDateTime);
    }

    public MessageSecurityState withMessageReceivedDateTime(OffsetDateTime messageReceivedDateTime) {
        MessageSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageSecurityState");
        _x.messageReceivedDateTime = messageReceivedDateTime;
        return _x;
    }

    @Property(name="messageSubject")
    @JsonIgnore
    public Optional<String> getMessageSubject() {
        return Optional.ofNullable(messageSubject);
    }

    public MessageSecurityState withMessageSubject(String messageSubject) {
        MessageSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageSecurityState");
        _x.messageSubject = messageSubject;
        return _x;
    }

    @Property(name="networkMessageId")
    @JsonIgnore
    public Optional<String> getNetworkMessageId() {
        return Optional.ofNullable(networkMessageId);
    }

    public MessageSecurityState withNetworkMessageId(String networkMessageId) {
        MessageSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageSecurityState");
        _x.networkMessageId = networkMessageId;
        return _x;
    }

    public MessageSecurityState withUnmappedField(String name, Object value) {
        MessageSecurityState _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String connectingIP;
        private String deliveryAction;
        private String deliveryLocation;
        private String directionality;
        private String internetMessageId;
        private String messageFingerprint;
        private OffsetDateTime messageReceivedDateTime;
        private String messageSubject;
        private String networkMessageId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder connectingIP(String connectingIP) {
            this.connectingIP = connectingIP;
            this.changedFields = changedFields.add("connectingIP");
            return this;
        }

        public Builder deliveryAction(String deliveryAction) {
            this.deliveryAction = deliveryAction;
            this.changedFields = changedFields.add("deliveryAction");
            return this;
        }

        public Builder deliveryLocation(String deliveryLocation) {
            this.deliveryLocation = deliveryLocation;
            this.changedFields = changedFields.add("deliveryLocation");
            return this;
        }

        public Builder directionality(String directionality) {
            this.directionality = directionality;
            this.changedFields = changedFields.add("directionality");
            return this;
        }

        public Builder internetMessageId(String internetMessageId) {
            this.internetMessageId = internetMessageId;
            this.changedFields = changedFields.add("internetMessageId");
            return this;
        }

        public Builder messageFingerprint(String messageFingerprint) {
            this.messageFingerprint = messageFingerprint;
            this.changedFields = changedFields.add("messageFingerprint");
            return this;
        }

        public Builder messageReceivedDateTime(OffsetDateTime messageReceivedDateTime) {
            this.messageReceivedDateTime = messageReceivedDateTime;
            this.changedFields = changedFields.add("messageReceivedDateTime");
            return this;
        }

        public Builder messageSubject(String messageSubject) {
            this.messageSubject = messageSubject;
            this.changedFields = changedFields.add("messageSubject");
            return this;
        }

        public Builder networkMessageId(String networkMessageId) {
            this.networkMessageId = networkMessageId;
            this.changedFields = changedFields.add("networkMessageId");
            return this;
        }

        public MessageSecurityState build() {
            MessageSecurityState _x = new MessageSecurityState();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.messageSecurityState";
            _x.connectingIP = connectingIP;
            _x.deliveryAction = deliveryAction;
            _x.deliveryLocation = deliveryLocation;
            _x.directionality = directionality;
            _x.internetMessageId = internetMessageId;
            _x.messageFingerprint = messageFingerprint;
            _x.messageReceivedDateTime = messageReceivedDateTime;
            _x.messageSubject = messageSubject;
            _x.networkMessageId = networkMessageId;
            return _x;
        }
    }

    private MessageSecurityState _copy() {
        MessageSecurityState _x = new MessageSecurityState();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.connectingIP = connectingIP;
        _x.deliveryAction = deliveryAction;
        _x.deliveryLocation = deliveryLocation;
        _x.directionality = directionality;
        _x.internetMessageId = internetMessageId;
        _x.messageFingerprint = messageFingerprint;
        _x.messageReceivedDateTime = messageReceivedDateTime;
        _x.messageSubject = messageSubject;
        _x.networkMessageId = networkMessageId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MessageSecurityState[");
        b.append("connectingIP=");
        b.append(this.connectingIP);
        b.append(", ");
        b.append("deliveryAction=");
        b.append(this.deliveryAction);
        b.append(", ");
        b.append("deliveryLocation=");
        b.append(this.deliveryLocation);
        b.append(", ");
        b.append("directionality=");
        b.append(this.directionality);
        b.append(", ");
        b.append("internetMessageId=");
        b.append(this.internetMessageId);
        b.append(", ");
        b.append("messageFingerprint=");
        b.append(this.messageFingerprint);
        b.append(", ");
        b.append("messageReceivedDateTime=");
        b.append(this.messageReceivedDateTime);
        b.append(", ");
        b.append("messageSubject=");
        b.append(this.messageSubject);
        b.append(", ");
        b.append("networkMessageId=");
        b.append(this.networkMessageId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
