package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.MembershipRuleProcessingStatusDetails;

@JsonPropertyOrder({
    "@odata.type", 
    "errorMessage", 
    "lastMembershipUpdated", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class MembershipRuleProcessingStatus implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("errorMessage")
    protected String errorMessage;

    @JsonProperty("lastMembershipUpdated")
    protected OffsetDateTime lastMembershipUpdated;

    @JsonProperty("status")
    protected MembershipRuleProcessingStatusDetails status;

    protected MembershipRuleProcessingStatus() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.membershipRuleProcessingStatus";
    }

    @Property(name="errorMessage")
    @JsonIgnore
    public Optional<String> getErrorMessage() {
        return Optional.ofNullable(errorMessage);
    }

    public MembershipRuleProcessingStatus withErrorMessage(String errorMessage) {
        MembershipRuleProcessingStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.membershipRuleProcessingStatus");
        _x.errorMessage = errorMessage;
        return _x;
    }

    @Property(name="lastMembershipUpdated")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastMembershipUpdated() {
        return Optional.ofNullable(lastMembershipUpdated);
    }

    public MembershipRuleProcessingStatus withLastMembershipUpdated(OffsetDateTime lastMembershipUpdated) {
        MembershipRuleProcessingStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.membershipRuleProcessingStatus");
        _x.lastMembershipUpdated = lastMembershipUpdated;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<MembershipRuleProcessingStatusDetails> getStatus() {
        return Optional.ofNullable(status);
    }

    public MembershipRuleProcessingStatus withStatus(MembershipRuleProcessingStatusDetails status) {
        MembershipRuleProcessingStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.membershipRuleProcessingStatus");
        _x.status = status;
        return _x;
    }

    public MembershipRuleProcessingStatus withUnmappedField(String name, Object value) {
        MembershipRuleProcessingStatus _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String errorMessage;
        private OffsetDateTime lastMembershipUpdated;
        private MembershipRuleProcessingStatusDetails status;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            this.changedFields = changedFields.add("errorMessage");
            return this;
        }

        public Builder lastMembershipUpdated(OffsetDateTime lastMembershipUpdated) {
            this.lastMembershipUpdated = lastMembershipUpdated;
            this.changedFields = changedFields.add("lastMembershipUpdated");
            return this;
        }

        public Builder status(MembershipRuleProcessingStatusDetails status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public MembershipRuleProcessingStatus build() {
            MembershipRuleProcessingStatus _x = new MembershipRuleProcessingStatus();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.membershipRuleProcessingStatus";
            _x.errorMessage = errorMessage;
            _x.lastMembershipUpdated = lastMembershipUpdated;
            _x.status = status;
            return _x;
        }
    }

    private MembershipRuleProcessingStatus _copy() {
        MembershipRuleProcessingStatus _x = new MembershipRuleProcessingStatus();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.errorMessage = errorMessage;
        _x.lastMembershipUpdated = lastMembershipUpdated;
        _x.status = status;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MembershipRuleProcessingStatus[");
        b.append("errorMessage=");
        b.append(this.errorMessage);
        b.append(", ");
        b.append("lastMembershipUpdated=");
        b.append(this.lastMembershipUpdated);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
