package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "attendees", 
    "contributors", 
    "organizer", 
    "producers"})
@JsonInclude(Include.NON_NULL)
public class MeetingParticipants implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("attendees")
    protected List<MeetingParticipantInfo> attendees;

    @JsonProperty("attendees@nextLink")
    protected String attendeesNextLink;

    @JsonProperty("contributors")
    protected List<MeetingParticipantInfo> contributors;

    @JsonProperty("contributors@nextLink")
    protected String contributorsNextLink;

    @JsonProperty("organizer")
    protected MeetingParticipantInfo organizer;

    @JsonProperty("producers")
    protected List<MeetingParticipantInfo> producers;

    @JsonProperty("producers@nextLink")
    protected String producersNextLink;

    protected MeetingParticipants() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.meetingParticipants";
    }

    @Property(name="attendees")
    @JsonIgnore
    public CollectionPage<MeetingParticipantInfo> getAttendees() {
        return new CollectionPage<MeetingParticipantInfo>(contextPath, MeetingParticipantInfo.class, this.attendees, Optional.ofNullable(attendeesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="attendees")
    @JsonIgnore
    public CollectionPage<MeetingParticipantInfo> getAttendees(HttpRequestOptions options) {
        return new CollectionPage<MeetingParticipantInfo>(contextPath, MeetingParticipantInfo.class, this.attendees, Optional.ofNullable(attendeesNextLink), Collections.emptyList(), options);
    }

    @Property(name="contributors")
    @JsonIgnore
    public CollectionPage<MeetingParticipantInfo> getContributors() {
        return new CollectionPage<MeetingParticipantInfo>(contextPath, MeetingParticipantInfo.class, this.contributors, Optional.ofNullable(contributorsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="contributors")
    @JsonIgnore
    public CollectionPage<MeetingParticipantInfo> getContributors(HttpRequestOptions options) {
        return new CollectionPage<MeetingParticipantInfo>(contextPath, MeetingParticipantInfo.class, this.contributors, Optional.ofNullable(contributorsNextLink), Collections.emptyList(), options);
    }

    @Property(name="organizer")
    @JsonIgnore
    public Optional<MeetingParticipantInfo> getOrganizer() {
        return Optional.ofNullable(organizer);
    }

    public MeetingParticipants withOrganizer(MeetingParticipantInfo organizer) {
        MeetingParticipants _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingParticipants");
        _x.organizer = organizer;
        return _x;
    }

    @Property(name="producers")
    @JsonIgnore
    public CollectionPage<MeetingParticipantInfo> getProducers() {
        return new CollectionPage<MeetingParticipantInfo>(contextPath, MeetingParticipantInfo.class, this.producers, Optional.ofNullable(producersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="producers")
    @JsonIgnore
    public CollectionPage<MeetingParticipantInfo> getProducers(HttpRequestOptions options) {
        return new CollectionPage<MeetingParticipantInfo>(contextPath, MeetingParticipantInfo.class, this.producers, Optional.ofNullable(producersNextLink), Collections.emptyList(), options);
    }

    public MeetingParticipants withUnmappedField(String name, Object value) {
        MeetingParticipants _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<MeetingParticipantInfo> attendees;
        private String attendeesNextLink;
        private List<MeetingParticipantInfo> contributors;
        private String contributorsNextLink;
        private MeetingParticipantInfo organizer;
        private List<MeetingParticipantInfo> producers;
        private String producersNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder attendees(List<MeetingParticipantInfo> attendees) {
            this.attendees = attendees;
            this.changedFields = changedFields.add("attendees");
            return this;
        }

        public Builder attendees(MeetingParticipantInfo... attendees) {
            return attendees(Arrays.asList(attendees));
        }

        public Builder attendeesNextLink(String attendeesNextLink) {
            this.attendeesNextLink = attendeesNextLink;
            this.changedFields = changedFields.add("attendees");
            return this;
        }

        public Builder contributors(List<MeetingParticipantInfo> contributors) {
            this.contributors = contributors;
            this.changedFields = changedFields.add("contributors");
            return this;
        }

        public Builder contributors(MeetingParticipantInfo... contributors) {
            return contributors(Arrays.asList(contributors));
        }

        public Builder contributorsNextLink(String contributorsNextLink) {
            this.contributorsNextLink = contributorsNextLink;
            this.changedFields = changedFields.add("contributors");
            return this;
        }

        public Builder organizer(MeetingParticipantInfo organizer) {
            this.organizer = organizer;
            this.changedFields = changedFields.add("organizer");
            return this;
        }

        public Builder producers(List<MeetingParticipantInfo> producers) {
            this.producers = producers;
            this.changedFields = changedFields.add("producers");
            return this;
        }

        public Builder producers(MeetingParticipantInfo... producers) {
            return producers(Arrays.asList(producers));
        }

        public Builder producersNextLink(String producersNextLink) {
            this.producersNextLink = producersNextLink;
            this.changedFields = changedFields.add("producers");
            return this;
        }

        public MeetingParticipants build() {
            MeetingParticipants _x = new MeetingParticipants();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.meetingParticipants";
            _x.attendees = attendees;
            _x.attendeesNextLink = attendeesNextLink;
            _x.contributors = contributors;
            _x.contributorsNextLink = contributorsNextLink;
            _x.organizer = organizer;
            _x.producers = producers;
            _x.producersNextLink = producersNextLink;
            return _x;
        }
    }

    private MeetingParticipants _copy() {
        MeetingParticipants _x = new MeetingParticipants();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.attendees = attendees;
        _x.contributors = contributors;
        _x.organizer = organizer;
        _x.producers = producers;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MeetingParticipants[");
        b.append("attendees=");
        b.append(this.attendees);
        b.append(", ");
        b.append("contributors=");
        b.append(this.contributors);
        b.append(", ");
        b.append("organizer=");
        b.append(this.organizer);
        b.append(", ");
        b.append("producers=");
        b.append(this.producers);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
