package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.OnlineMeetingRole;

@JsonPropertyOrder({
    "@odata.type", 
    "identity", 
    "role", 
    "upn"})
@JsonInclude(Include.NON_NULL)
public class MeetingParticipantInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("identity")
    protected IdentitySet identity;

    @JsonProperty("role")
    protected OnlineMeetingRole role;

    @JsonProperty("upn")
    protected String upn;

    protected MeetingParticipantInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.meetingParticipantInfo";
    }

    @Property(name="identity")
    @JsonIgnore
    public Optional<IdentitySet> getIdentity() {
        return Optional.ofNullable(identity);
    }

    public MeetingParticipantInfo withIdentity(IdentitySet identity) {
        MeetingParticipantInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingParticipantInfo");
        _x.identity = identity;
        return _x;
    }

    @Property(name="role")
    @JsonIgnore
    public Optional<OnlineMeetingRole> getRole() {
        return Optional.ofNullable(role);
    }

    public MeetingParticipantInfo withRole(OnlineMeetingRole role) {
        MeetingParticipantInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingParticipantInfo");
        _x.role = role;
        return _x;
    }

    @Property(name="upn")
    @JsonIgnore
    public Optional<String> getUpn() {
        return Optional.ofNullable(upn);
    }

    public MeetingParticipantInfo withUpn(String upn) {
        MeetingParticipantInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingParticipantInfo");
        _x.upn = upn;
        return _x;
    }

    public MeetingParticipantInfo withUnmappedField(String name, Object value) {
        MeetingParticipantInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IdentitySet identity;
        private OnlineMeetingRole role;
        private String upn;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder identity(IdentitySet identity) {
            this.identity = identity;
            this.changedFields = changedFields.add("identity");
            return this;
        }

        public Builder role(OnlineMeetingRole role) {
            this.role = role;
            this.changedFields = changedFields.add("role");
            return this;
        }

        public Builder upn(String upn) {
            this.upn = upn;
            this.changedFields = changedFields.add("upn");
            return this;
        }

        public MeetingParticipantInfo build() {
            MeetingParticipantInfo _x = new MeetingParticipantInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.meetingParticipantInfo";
            _x.identity = identity;
            _x.role = role;
            _x.upn = upn;
            return _x;
        }
    }

    private MeetingParticipantInfo _copy() {
        MeetingParticipantInfo _x = new MeetingParticipantInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.identity = identity;
        _x.role = role;
        _x.upn = upn;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MeetingParticipantInfo[");
        b.append("identity=");
        b.append(this.identity);
        b.append(", ");
        b.append("role=");
        b.append(this.role);
        b.append(", ");
        b.append("upn=");
        b.append(this.upn);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
