package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.MediaDirection;
import odata.msgraph.client.beta.enums.Modality;

@JsonPropertyOrder({
    "@odata.type", 
    "direction", 
    "label", 
    "mediaType", 
    "serverMuted", 
    "sourceId"})
@JsonInclude(Include.NON_NULL)
public class MediaStream implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("direction")
    protected MediaDirection direction;

    @JsonProperty("label")
    protected String label;

    @JsonProperty("mediaType")
    protected Modality mediaType;

    @JsonProperty("serverMuted")
    protected Boolean serverMuted;

    @JsonProperty("sourceId")
    protected String sourceId;

    protected MediaStream() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mediaStream";
    }

    @Property(name="direction")
    @JsonIgnore
    public Optional<MediaDirection> getDirection() {
        return Optional.ofNullable(direction);
    }

    public MediaStream withDirection(MediaDirection direction) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mediaStream");
        _x.direction = direction;
        return _x;
    }

    @Property(name="label")
    @JsonIgnore
    public Optional<String> getLabel() {
        return Optional.ofNullable(label);
    }

    public MediaStream withLabel(String label) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mediaStream");
        _x.label = label;
        return _x;
    }

    @Property(name="mediaType")
    @JsonIgnore
    public Optional<Modality> getMediaType() {
        return Optional.ofNullable(mediaType);
    }

    public MediaStream withMediaType(Modality mediaType) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mediaStream");
        _x.mediaType = mediaType;
        return _x;
    }

    @Property(name="serverMuted")
    @JsonIgnore
    public Optional<Boolean> getServerMuted() {
        return Optional.ofNullable(serverMuted);
    }

    public MediaStream withServerMuted(Boolean serverMuted) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mediaStream");
        _x.serverMuted = serverMuted;
        return _x;
    }

    @Property(name="sourceId")
    @JsonIgnore
    public Optional<String> getSourceId() {
        return Optional.ofNullable(sourceId);
    }

    public MediaStream withSourceId(String sourceId) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mediaStream");
        _x.sourceId = sourceId;
        return _x;
    }

    public MediaStream withUnmappedField(String name, Object value) {
        MediaStream _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private MediaDirection direction;
        private String label;
        private Modality mediaType;
        private Boolean serverMuted;
        private String sourceId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder direction(MediaDirection direction) {
            this.direction = direction;
            this.changedFields = changedFields.add("direction");
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            this.changedFields = changedFields.add("label");
            return this;
        }

        public Builder mediaType(Modality mediaType) {
            this.mediaType = mediaType;
            this.changedFields = changedFields.add("mediaType");
            return this;
        }

        public Builder serverMuted(Boolean serverMuted) {
            this.serverMuted = serverMuted;
            this.changedFields = changedFields.add("serverMuted");
            return this;
        }

        public Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            this.changedFields = changedFields.add("sourceId");
            return this;
        }

        public MediaStream build() {
            MediaStream _x = new MediaStream();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.mediaStream";
            _x.direction = direction;
            _x.label = label;
            _x.mediaType = mediaType;
            _x.serverMuted = serverMuted;
            _x.sourceId = sourceId;
            return _x;
        }
    }

    private MediaStream _copy() {
        MediaStream _x = new MediaStream();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.direction = direction;
        _x.label = label;
        _x.mediaType = mediaType;
        _x.serverMuted = serverMuted;
        _x.sourceId = sourceId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MediaStream[");
        b.append("direction=");
        b.append(this.direction);
        b.append(", ");
        b.append("label=");
        b.append(this.label);
        b.append(", ");
        b.append("mediaType=");
        b.append(this.mediaType);
        b.append(", ");
        b.append("serverMuted=");
        b.append(this.serverMuted);
        b.append(", ");
        b.append("sourceId=");
        b.append(this.sourceId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
