package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "fontColor", 
    "fontSize", 
    "text"})
@JsonInclude(Include.NON_NULL)
public class MarkContent extends LabelActionBase implements ODataType {

    @JsonProperty("fontColor")
    protected String fontColor;

    @JsonProperty("fontSize")
    protected Long fontSize;

    @JsonProperty("text")
    protected String text;

    protected MarkContent() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.markContent";
    }

    @Property(name="fontColor")
    @JsonIgnore
    public Optional<String> getFontColor() {
        return Optional.ofNullable(fontColor);
    }

    public MarkContent withFontColor(String fontColor) {
        MarkContent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.markContent");
        _x.fontColor = fontColor;
        return _x;
    }

    @Property(name="fontSize")
    @JsonIgnore
    public Optional<Long> getFontSize() {
        return Optional.ofNullable(fontSize);
    }

    public MarkContent withFontSize(Long fontSize) {
        MarkContent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.markContent");
        _x.fontSize = fontSize;
        return _x;
    }

    @Property(name="text")
    @JsonIgnore
    public Optional<String> getText() {
        return Optional.ofNullable(text);
    }

    public MarkContent withText(String text) {
        MarkContent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.markContent");
        _x.text = text;
        return _x;
    }

    public MarkContent withUnmappedField(String name, Object value) {
        MarkContent _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    private MarkContent _copy() {
        MarkContent _x = new MarkContent();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.name = name;
        _x.fontColor = fontColor;
        _x.fontSize = fontSize;
        _x.text = text;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MarkContent[");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("fontColor=");
        b.append(this.fontColor);
        b.append(", ");
        b.append("fontSize=");
        b.append(this.fontSize);
        b.append(", ");
        b.append("text=");
        b.append(this.text);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
