package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.RunState;


/**
 * <i>“Event representing a user's devices with failed or pending apps.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deviceId", 
    "summarizedAppState"})
@JsonInclude(Include.NON_NULL)
public class ManagedDeviceSummarizedAppState implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("deviceId")
    protected String deviceId;

    @JsonProperty("summarizedAppState")
    protected RunState summarizedAppState;

    protected ManagedDeviceSummarizedAppState() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedDeviceSummarizedAppState";
    }

    /**
     * <i>“DeviceId of device represented by this object”</i>
     * 
     * @return property deviceId
     */
    @Property(name="deviceId")
    @JsonIgnore
    public Optional<String> getDeviceId() {
        return Optional.ofNullable(deviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“DeviceId of device represented by this object”</i>
     * 
     * @param deviceId
     *            new value of {@code deviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceId} field changed
     */
    public ManagedDeviceSummarizedAppState withDeviceId(String deviceId) {
        ManagedDeviceSummarizedAppState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceSummarizedAppState");
        _x.deviceId = deviceId;
        return _x;
    }

    /**
     * <i>“runState for the object”</i>
     * 
     * @return property summarizedAppState
     */
    @Property(name="summarizedAppState")
    @JsonIgnore
    public Optional<RunState> getSummarizedAppState() {
        return Optional.ofNullable(summarizedAppState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * summarizedAppState} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“runState for the object”</i>
     * 
     * @param summarizedAppState
     *            new value of {@code summarizedAppState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code summarizedAppState} field changed
     */
    public ManagedDeviceSummarizedAppState withSummarizedAppState(RunState summarizedAppState) {
        ManagedDeviceSummarizedAppState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceSummarizedAppState");
        _x.summarizedAppState = summarizedAppState;
        return _x;
    }

    public ManagedDeviceSummarizedAppState withUnmappedField(String name, Object value) {
        ManagedDeviceSummarizedAppState _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String deviceId;
        private RunState summarizedAppState;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“DeviceId of device represented by this object”</i>
         * 
         * @param deviceId
         *            value of {@code deviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            this.changedFields = changedFields.add("deviceId");
            return this;
        }

        /**
         * <i>“runState for the object”</i>
         * 
         * @param summarizedAppState
         *            value of {@code summarizedAppState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder summarizedAppState(RunState summarizedAppState) {
            this.summarizedAppState = summarizedAppState;
            this.changedFields = changedFields.add("summarizedAppState");
            return this;
        }

        public ManagedDeviceSummarizedAppState build() {
            ManagedDeviceSummarizedAppState _x = new ManagedDeviceSummarizedAppState();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedDeviceSummarizedAppState";
            _x.deviceId = deviceId;
            _x.summarizedAppState = summarizedAppState;
            return _x;
        }
    }

    private ManagedDeviceSummarizedAppState _copy() {
        ManagedDeviceSummarizedAppState _x = new ManagedDeviceSummarizedAppState();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.deviceId = deviceId;
        _x.summarizedAppState = summarizedAppState;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagedDeviceSummarizedAppState[");
        b.append("deviceId=");
        b.append(this.deviceId);
        b.append(", ");
        b.append("summarizedAppState=");
        b.append(this.summarizedAppState);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
