package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Application data for reporting”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "appId"})
@JsonInclude(Include.NON_NULL)
public class ManagedDeviceReportedApp implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("appId")
    protected String appId;

    protected ManagedDeviceReportedApp() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedDeviceReportedApp";
    }

    /**
     * <i>“The application or bundle identifier of the application”</i>
     * 
     * @return property appId
     */
    @Property(name="appId")
    @JsonIgnore
    public Optional<String> getAppId() {
        return Optional.ofNullable(appId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The application or bundle identifier of the application”</i>
     * 
     * @param appId
     *            new value of {@code appId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appId} field changed
     */
    public ManagedDeviceReportedApp withAppId(String appId) {
        ManagedDeviceReportedApp _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceReportedApp");
        _x.appId = appId;
        return _x;
    }

    public ManagedDeviceReportedApp withUnmappedField(String name, Object value) {
        ManagedDeviceReportedApp _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String appId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The application or bundle identifier of the application”</i>
         * 
         * @param appId
         *            value of {@code appId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appId(String appId) {
            this.appId = appId;
            this.changedFields = changedFields.add("appId");
            return this;
        }

        public ManagedDeviceReportedApp build() {
            ManagedDeviceReportedApp _x = new ManagedDeviceReportedApp();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedDeviceReportedApp";
            _x.appId = appId;
            return _x;
        }
    }

    private ManagedDeviceReportedApp _copy() {
        ManagedDeviceReportedApp _x = new ManagedDeviceReportedApp();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.appId = appId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagedDeviceReportedApp[");
        b.append("appId=");
        b.append(this.appId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
