package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DelegateMeetingMessageDeliveryOptions;
import odata.msgraph.client.beta.enums.MailboxRecipientType;
import odata.msgraph.client.beta.enums.UserPurpose;

@JsonPropertyOrder({
    "@odata.type", 
    "archiveFolder", 
    "automaticRepliesSetting", 
    "dateFormat", 
    "delegateMeetingMessageDeliveryOptions", 
    "language", 
    "timeFormat", 
    "timeZone", 
    "userPurpose", 
    "userPurposeV2", 
    "workingHours"})
@JsonInclude(Include.NON_NULL)
public class MailboxSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("archiveFolder")
    protected String archiveFolder;

    @JsonProperty("automaticRepliesSetting")
    protected AutomaticRepliesSetting automaticRepliesSetting;

    @JsonProperty("dateFormat")
    protected String dateFormat;

    @JsonProperty("delegateMeetingMessageDeliveryOptions")
    protected DelegateMeetingMessageDeliveryOptions delegateMeetingMessageDeliveryOptions;

    @JsonProperty("language")
    protected LocaleInfo language;

    @JsonProperty("timeFormat")
    protected String timeFormat;

    @JsonProperty("timeZone")
    protected String timeZone;

    @JsonProperty("userPurpose")
    protected UserPurpose userPurpose;

    @JsonProperty("userPurposeV2")
    protected MailboxRecipientType userPurposeV2;

    @JsonProperty("workingHours")
    protected WorkingHours workingHours;

    protected MailboxSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mailboxSettings";
    }

    @Property(name="archiveFolder")
    @JsonIgnore
    public Optional<String> getArchiveFolder() {
        return Optional.ofNullable(archiveFolder);
    }

    public MailboxSettings withArchiveFolder(String archiveFolder) {
        MailboxSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailboxSettings");
        _x.archiveFolder = archiveFolder;
        return _x;
    }

    @Property(name="automaticRepliesSetting")
    @JsonIgnore
    public Optional<AutomaticRepliesSetting> getAutomaticRepliesSetting() {
        return Optional.ofNullable(automaticRepliesSetting);
    }

    public MailboxSettings withAutomaticRepliesSetting(AutomaticRepliesSetting automaticRepliesSetting) {
        MailboxSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailboxSettings");
        _x.automaticRepliesSetting = automaticRepliesSetting;
        return _x;
    }

    @Property(name="dateFormat")
    @JsonIgnore
    public Optional<String> getDateFormat() {
        return Optional.ofNullable(dateFormat);
    }

    public MailboxSettings withDateFormat(String dateFormat) {
        MailboxSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailboxSettings");
        _x.dateFormat = dateFormat;
        return _x;
    }

    @Property(name="delegateMeetingMessageDeliveryOptions")
    @JsonIgnore
    public Optional<DelegateMeetingMessageDeliveryOptions> getDelegateMeetingMessageDeliveryOptions() {
        return Optional.ofNullable(delegateMeetingMessageDeliveryOptions);
    }

    public MailboxSettings withDelegateMeetingMessageDeliveryOptions(DelegateMeetingMessageDeliveryOptions delegateMeetingMessageDeliveryOptions) {
        MailboxSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailboxSettings");
        _x.delegateMeetingMessageDeliveryOptions = delegateMeetingMessageDeliveryOptions;
        return _x;
    }

    @Property(name="language")
    @JsonIgnore
    public Optional<LocaleInfo> getLanguage() {
        return Optional.ofNullable(language);
    }

    public MailboxSettings withLanguage(LocaleInfo language) {
        MailboxSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailboxSettings");
        _x.language = language;
        return _x;
    }

    @Property(name="timeFormat")
    @JsonIgnore
    public Optional<String> getTimeFormat() {
        return Optional.ofNullable(timeFormat);
    }

    public MailboxSettings withTimeFormat(String timeFormat) {
        MailboxSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailboxSettings");
        _x.timeFormat = timeFormat;
        return _x;
    }

    @Property(name="timeZone")
    @JsonIgnore
    public Optional<String> getTimeZone() {
        return Optional.ofNullable(timeZone);
    }

    public MailboxSettings withTimeZone(String timeZone) {
        MailboxSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailboxSettings");
        _x.timeZone = timeZone;
        return _x;
    }

    @Property(name="userPurpose")
    @JsonIgnore
    public Optional<UserPurpose> getUserPurpose() {
        return Optional.ofNullable(userPurpose);
    }

    public MailboxSettings withUserPurpose(UserPurpose userPurpose) {
        MailboxSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailboxSettings");
        _x.userPurpose = userPurpose;
        return _x;
    }

    @Property(name="userPurposeV2")
    @JsonIgnore
    public Optional<MailboxRecipientType> getUserPurposeV2() {
        return Optional.ofNullable(userPurposeV2);
    }

    public MailboxSettings withUserPurposeV2(MailboxRecipientType userPurposeV2) {
        MailboxSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailboxSettings");
        _x.userPurposeV2 = userPurposeV2;
        return _x;
    }

    @Property(name="workingHours")
    @JsonIgnore
    public Optional<WorkingHours> getWorkingHours() {
        return Optional.ofNullable(workingHours);
    }

    public MailboxSettings withWorkingHours(WorkingHours workingHours) {
        MailboxSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailboxSettings");
        _x.workingHours = workingHours;
        return _x;
    }

    public MailboxSettings withUnmappedField(String name, Object value) {
        MailboxSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String archiveFolder;
        private AutomaticRepliesSetting automaticRepliesSetting;
        private String dateFormat;
        private DelegateMeetingMessageDeliveryOptions delegateMeetingMessageDeliveryOptions;
        private LocaleInfo language;
        private String timeFormat;
        private String timeZone;
        private UserPurpose userPurpose;
        private MailboxRecipientType userPurposeV2;
        private WorkingHours workingHours;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder archiveFolder(String archiveFolder) {
            this.archiveFolder = archiveFolder;
            this.changedFields = changedFields.add("archiveFolder");
            return this;
        }

        public Builder automaticRepliesSetting(AutomaticRepliesSetting automaticRepliesSetting) {
            this.automaticRepliesSetting = automaticRepliesSetting;
            this.changedFields = changedFields.add("automaticRepliesSetting");
            return this;
        }

        public Builder dateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            this.changedFields = changedFields.add("dateFormat");
            return this;
        }

        public Builder delegateMeetingMessageDeliveryOptions(DelegateMeetingMessageDeliveryOptions delegateMeetingMessageDeliveryOptions) {
            this.delegateMeetingMessageDeliveryOptions = delegateMeetingMessageDeliveryOptions;
            this.changedFields = changedFields.add("delegateMeetingMessageDeliveryOptions");
            return this;
        }

        public Builder language(LocaleInfo language) {
            this.language = language;
            this.changedFields = changedFields.add("language");
            return this;
        }

        public Builder timeFormat(String timeFormat) {
            this.timeFormat = timeFormat;
            this.changedFields = changedFields.add("timeFormat");
            return this;
        }

        public Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            this.changedFields = changedFields.add("timeZone");
            return this;
        }

        public Builder userPurpose(UserPurpose userPurpose) {
            this.userPurpose = userPurpose;
            this.changedFields = changedFields.add("userPurpose");
            return this;
        }

        public Builder userPurposeV2(MailboxRecipientType userPurposeV2) {
            this.userPurposeV2 = userPurposeV2;
            this.changedFields = changedFields.add("userPurposeV2");
            return this;
        }

        public Builder workingHours(WorkingHours workingHours) {
            this.workingHours = workingHours;
            this.changedFields = changedFields.add("workingHours");
            return this;
        }

        public MailboxSettings build() {
            MailboxSettings _x = new MailboxSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.mailboxSettings";
            _x.archiveFolder = archiveFolder;
            _x.automaticRepliesSetting = automaticRepliesSetting;
            _x.dateFormat = dateFormat;
            _x.delegateMeetingMessageDeliveryOptions = delegateMeetingMessageDeliveryOptions;
            _x.language = language;
            _x.timeFormat = timeFormat;
            _x.timeZone = timeZone;
            _x.userPurpose = userPurpose;
            _x.userPurposeV2 = userPurposeV2;
            _x.workingHours = workingHours;
            return _x;
        }
    }

    private MailboxSettings _copy() {
        MailboxSettings _x = new MailboxSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.archiveFolder = archiveFolder;
        _x.automaticRepliesSetting = automaticRepliesSetting;
        _x.dateFormat = dateFormat;
        _x.delegateMeetingMessageDeliveryOptions = delegateMeetingMessageDeliveryOptions;
        _x.language = language;
        _x.timeFormat = timeFormat;
        _x.timeZone = timeZone;
        _x.userPurpose = userPurpose;
        _x.userPurposeV2 = userPurposeV2;
        _x.workingHours = workingHours;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MailboxSettings[");
        b.append("archiveFolder=");
        b.append(this.archiveFolder);
        b.append(", ");
        b.append("automaticRepliesSetting=");
        b.append(this.automaticRepliesSetting);
        b.append(", ");
        b.append("dateFormat=");
        b.append(this.dateFormat);
        b.append(", ");
        b.append("delegateMeetingMessageDeliveryOptions=");
        b.append(this.delegateMeetingMessageDeliveryOptions);
        b.append(", ");
        b.append("language=");
        b.append(this.language);
        b.append(", ");
        b.append("timeFormat=");
        b.append(this.timeFormat);
        b.append(", ");
        b.append("timeZone=");
        b.append(this.timeZone);
        b.append(", ");
        b.append("userPurpose=");
        b.append(this.userPurpose);
        b.append(", ");
        b.append("userPurposeV2=");
        b.append(this.userPurposeV2);
        b.append(", ");
        b.append("workingHours=");
        b.append(this.workingHours);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
