package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

import odata.msgraph.client.beta.enums.ClassificationMethod;
import odata.msgraph.client.beta.enums.MlClassificationMatchTolerance;
import odata.msgraph.client.beta.enums.SensitiveTypeScope;
import odata.msgraph.client.beta.enums.SensitiveTypeSource;

@JsonPropertyOrder({
    "@odata.type", 
    "matchTolerance", 
    "modelVersion"})
@JsonInclude(Include.NON_NULL)
public class MachineLearningDetectedSensitiveContent extends DetectedSensitiveContent implements ODataType {

    @JsonProperty("matchTolerance")
    protected MlClassificationMatchTolerance matchTolerance;

    @JsonProperty("modelVersion")
    protected String modelVersion;

    protected MachineLearningDetectedSensitiveContent() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.machineLearningDetectedSensitiveContent";
    }

    @Property(name="matchTolerance")
    @JsonIgnore
    public Optional<MlClassificationMatchTolerance> getMatchTolerance() {
        return Optional.ofNullable(matchTolerance);
    }

    public MachineLearningDetectedSensitiveContent withMatchTolerance(MlClassificationMatchTolerance matchTolerance) {
        MachineLearningDetectedSensitiveContent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.machineLearningDetectedSensitiveContent");
        _x.matchTolerance = matchTolerance;
        return _x;
    }

    @Property(name="modelVersion")
    @JsonIgnore
    public Optional<String> getModelVersion() {
        return Optional.ofNullable(modelVersion);
    }

    public MachineLearningDetectedSensitiveContent withModelVersion(String modelVersion) {
        MachineLearningDetectedSensitiveContent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.machineLearningDetectedSensitiveContent");
        _x.modelVersion = modelVersion;
        return _x;
    }

    public MachineLearningDetectedSensitiveContent withUnmappedField(String name, Object value) {
        MachineLearningDetectedSensitiveContent _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMachineLearningDetectedSensitiveContent() {
        return new Builder();
    }

    public static final class Builder {
        private Integer confidence;
        private String displayName;
        private UUID id;
        private Integer recommendedConfidence;
        private Integer uniqueCount;
        private List<ClassificationAttribute> classificationAttributes;
        private String classificationAttributesNextLink;
        private ClassificationMethod classificationMethod;
        private List<SensitiveContentLocation> matches;
        private String matchesNextLink;
        private SensitiveTypeScope scope;
        private SensitiveTypeSource sensitiveTypeSource;
        private MlClassificationMatchTolerance matchTolerance;
        private String modelVersion;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder confidence(Integer confidence) {
            this.confidence = confidence;
            this.changedFields = changedFields.add("confidence");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder id(UUID id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder recommendedConfidence(Integer recommendedConfidence) {
            this.recommendedConfidence = recommendedConfidence;
            this.changedFields = changedFields.add("recommendedConfidence");
            return this;
        }

        public Builder uniqueCount(Integer uniqueCount) {
            this.uniqueCount = uniqueCount;
            this.changedFields = changedFields.add("uniqueCount");
            return this;
        }

        public Builder classificationAttributes(List<ClassificationAttribute> classificationAttributes) {
            this.classificationAttributes = classificationAttributes;
            this.changedFields = changedFields.add("classificationAttributes");
            return this;
        }

        public Builder classificationAttributes(ClassificationAttribute... classificationAttributes) {
            return classificationAttributes(Arrays.asList(classificationAttributes));
        }

        public Builder classificationAttributesNextLink(String classificationAttributesNextLink) {
            this.classificationAttributesNextLink = classificationAttributesNextLink;
            this.changedFields = changedFields.add("classificationAttributes");
            return this;
        }

        public Builder classificationMethod(ClassificationMethod classificationMethod) {
            this.classificationMethod = classificationMethod;
            this.changedFields = changedFields.add("classificationMethod");
            return this;
        }

        public Builder matches(List<SensitiveContentLocation> matches) {
            this.matches = matches;
            this.changedFields = changedFields.add("matches");
            return this;
        }

        public Builder matches(SensitiveContentLocation... matches) {
            return matches(Arrays.asList(matches));
        }

        public Builder matchesNextLink(String matchesNextLink) {
            this.matchesNextLink = matchesNextLink;
            this.changedFields = changedFields.add("matches");
            return this;
        }

        public Builder scope(SensitiveTypeScope scope) {
            this.scope = scope;
            this.changedFields = changedFields.add("scope");
            return this;
        }

        public Builder sensitiveTypeSource(SensitiveTypeSource sensitiveTypeSource) {
            this.sensitiveTypeSource = sensitiveTypeSource;
            this.changedFields = changedFields.add("sensitiveTypeSource");
            return this;
        }

        public Builder matchTolerance(MlClassificationMatchTolerance matchTolerance) {
            this.matchTolerance = matchTolerance;
            this.changedFields = changedFields.add("matchTolerance");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.changedFields = changedFields.add("modelVersion");
            return this;
        }

        public MachineLearningDetectedSensitiveContent build() {
            MachineLearningDetectedSensitiveContent _x = new MachineLearningDetectedSensitiveContent();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.machineLearningDetectedSensitiveContent";
            _x.confidence = confidence;
            _x.displayName = displayName;
            _x.id = id;
            _x.recommendedConfidence = recommendedConfidence;
            _x.uniqueCount = uniqueCount;
            _x.classificationAttributes = classificationAttributes;
            _x.classificationAttributesNextLink = classificationAttributesNextLink;
            _x.classificationMethod = classificationMethod;
            _x.matches = matches;
            _x.matchesNextLink = matchesNextLink;
            _x.scope = scope;
            _x.sensitiveTypeSource = sensitiveTypeSource;
            _x.matchTolerance = matchTolerance;
            _x.modelVersion = modelVersion;
            return _x;
        }
    }

    private MachineLearningDetectedSensitiveContent _copy() {
        MachineLearningDetectedSensitiveContent _x = new MachineLearningDetectedSensitiveContent();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.confidence = confidence;
        _x.displayName = displayName;
        _x.id = id;
        _x.recommendedConfidence = recommendedConfidence;
        _x.uniqueCount = uniqueCount;
        _x.classificationAttributes = classificationAttributes;
        _x.classificationMethod = classificationMethod;
        _x.matches = matches;
        _x.scope = scope;
        _x.sensitiveTypeSource = sensitiveTypeSource;
        _x.matchTolerance = matchTolerance;
        _x.modelVersion = modelVersion;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MachineLearningDetectedSensitiveContent[");
        b.append("confidence=");
        b.append(this.confidence);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("recommendedConfidence=");
        b.append(this.recommendedConfidence);
        b.append(", ");
        b.append("uniqueCount=");
        b.append(this.uniqueCount);
        b.append(", ");
        b.append("classificationAttributes=");
        b.append(this.classificationAttributes);
        b.append(", ");
        b.append("classificationMethod=");
        b.append(this.classificationMethod);
        b.append(", ");
        b.append("matches=");
        b.append(this.matches);
        b.append(", ");
        b.append("scope=");
        b.append(this.scope);
        b.append(", ");
        b.append("sensitiveTypeSource=");
        b.append(this.sensitiveTypeSource);
        b.append(", ");
        b.append("matchTolerance=");
        b.append(this.matchTolerance);
        b.append(", ");
        b.append("modelVersion=");
        b.append(this.modelVersion);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
