package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Represents a specific macOS system extension.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "bundleId", 
    "teamIdentifier"})
@JsonInclude(Include.NON_NULL)
public class MacOSSystemExtension implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("bundleId")
    protected String bundleId;

    @JsonProperty("teamIdentifier")
    protected String teamIdentifier;

    protected MacOSSystemExtension() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.macOSSystemExtension";
    }

    /**
     * <i>“Gets or sets the bundle identifier of the system extension.”</i>
     * 
     * @return property bundleId
     */
    @Property(name="bundleId")
    @JsonIgnore
    public Optional<String> getBundleId() {
        return Optional.ofNullable(bundleId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code bundleId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Gets or sets the bundle identifier of the system extension.”</i>
     * 
     * @param bundleId
     *            new value of {@code bundleId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bundleId} field changed
     */
    public MacOSSystemExtension withBundleId(String bundleId) {
        MacOSSystemExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSSystemExtension");
        _x.bundleId = bundleId;
        return _x;
    }

    /**
     * <i>“Gets or sets the team identifier that was used to sign the system extension.”</i>
     * 
     * @return property teamIdentifier
     */
    @Property(name="teamIdentifier")
    @JsonIgnore
    public Optional<String> getTeamIdentifier() {
        return Optional.ofNullable(teamIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code teamIdentifier}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Gets or sets the team identifier that was used to sign the system extension.”</i>
     * 
     * @param teamIdentifier
     *            new value of {@code teamIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code teamIdentifier} field changed
     */
    public MacOSSystemExtension withTeamIdentifier(String teamIdentifier) {
        MacOSSystemExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSSystemExtension");
        _x.teamIdentifier = teamIdentifier;
        return _x;
    }

    public MacOSSystemExtension withUnmappedField(String name, Object value) {
        MacOSSystemExtension _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String bundleId;
        private String teamIdentifier;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Gets or sets the bundle identifier of the system extension.”</i>
         * 
         * @param bundleId
         *            value of {@code bundleId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            this.changedFields = changedFields.add("bundleId");
            return this;
        }

        /**
         * <i>“Gets or sets the team identifier that was used to sign the system extension.”</i>
         * 
         * @param teamIdentifier
         *            value of {@code teamIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder teamIdentifier(String teamIdentifier) {
            this.teamIdentifier = teamIdentifier;
            this.changedFields = changedFields.add("teamIdentifier");
            return this;
        }

        public MacOSSystemExtension build() {
            MacOSSystemExtension _x = new MacOSSystemExtension();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.macOSSystemExtension";
            _x.bundleId = bundleId;
            _x.teamIdentifier = teamIdentifier;
            return _x;
        }
    }

    private MacOSSystemExtension _copy() {
        MacOSSystemExtension _x = new MacOSSystemExtension();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.bundleId = bundleId;
        _x.teamIdentifier = teamIdentifier;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MacOSSystemExtension[");
        b.append("bundleId=");
        b.append(this.bundleId);
        b.append(", ");
        b.append("teamIdentifier=");
        b.append(this.teamIdentifier);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
