package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Contains properties the MacOS LOB App in a bundle package”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "buildNumber", 
    "bundleId", 
    "versionNumber"})
@JsonInclude(Include.NON_NULL)
public class MacOSLobChildApp implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("buildNumber")
    protected String buildNumber;

    @JsonProperty("bundleId")
    protected String bundleId;

    @JsonProperty("versionNumber")
    protected String versionNumber;

    protected MacOSLobChildApp() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.macOSLobChildApp";
    }

    /**
     * <i>“The build number of MacOS Line of Business (LoB) app.”</i>
     * 
     * @return property buildNumber
     */
    @Property(name="buildNumber")
    @JsonIgnore
    public Optional<String> getBuildNumber() {
        return Optional.ofNullable(buildNumber);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code buildNumber}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The build number of MacOS Line of Business (LoB) app.”</i>
     * 
     * @param buildNumber
     *            new value of {@code buildNumber} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code buildNumber} field changed
     */
    public MacOSLobChildApp withBuildNumber(String buildNumber) {
        MacOSLobChildApp _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSLobChildApp");
        _x.buildNumber = buildNumber;
        return _x;
    }

    /**
     * <i>“The Identity Name.”</i>
     * 
     * @return property bundleId
     */
    @Property(name="bundleId")
    @JsonIgnore
    public Optional<String> getBundleId() {
        return Optional.ofNullable(bundleId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code bundleId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The Identity Name.”</i>
     * 
     * @param bundleId
     *            new value of {@code bundleId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bundleId} field changed
     */
    public MacOSLobChildApp withBundleId(String bundleId) {
        MacOSLobChildApp _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSLobChildApp");
        _x.bundleId = bundleId;
        return _x;
    }

    /**
     * <i>“The version number of MacOS Line of Business (LoB) app.”</i>
     * 
     * @return property versionNumber
     */
    @Property(name="versionNumber")
    @JsonIgnore
    public Optional<String> getVersionNumber() {
        return Optional.ofNullable(versionNumber);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code versionNumber}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The version number of MacOS Line of Business (LoB) app.”</i>
     * 
     * @param versionNumber
     *            new value of {@code versionNumber} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code versionNumber} field changed
     */
    public MacOSLobChildApp withVersionNumber(String versionNumber) {
        MacOSLobChildApp _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSLobChildApp");
        _x.versionNumber = versionNumber;
        return _x;
    }

    public MacOSLobChildApp withUnmappedField(String name, Object value) {
        MacOSLobChildApp _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String buildNumber;
        private String bundleId;
        private String versionNumber;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The build number of MacOS Line of Business (LoB) app.”</i>
         * 
         * @param buildNumber
         *            value of {@code buildNumber} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder buildNumber(String buildNumber) {
            this.buildNumber = buildNumber;
            this.changedFields = changedFields.add("buildNumber");
            return this;
        }

        /**
         * <i>“The Identity Name.”</i>
         * 
         * @param bundleId
         *            value of {@code bundleId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            this.changedFields = changedFields.add("bundleId");
            return this;
        }

        /**
         * <i>“The version number of MacOS Line of Business (LoB) app.”</i>
         * 
         * @param versionNumber
         *            value of {@code versionNumber} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder versionNumber(String versionNumber) {
            this.versionNumber = versionNumber;
            this.changedFields = changedFields.add("versionNumber");
            return this;
        }

        public MacOSLobChildApp build() {
            MacOSLobChildApp _x = new MacOSLobChildApp();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.macOSLobChildApp";
            _x.buildNumber = buildNumber;
            _x.bundleId = bundleId;
            _x.versionNumber = versionNumber;
            return _x;
        }
    }

    private MacOSLobChildApp _copy() {
        MacOSLobChildApp _x = new MacOSLobChildApp();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.buildNumber = buildNumber;
        _x.bundleId = bundleId;
        _x.versionNumber = versionNumber;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MacOSLobChildApp[");
        b.append("buildNumber=");
        b.append(this.buildNumber);
        b.append(", ");
        b.append("bundleId=");
        b.append(this.bundleId);
        b.append(", ");
        b.append("versionNumber=");
        b.append(this.versionNumber);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
