package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Represents an app in the list of macOS launch items”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "hide", 
    "path"})
@JsonInclude(Include.NON_NULL)
public class MacOSLaunchItem implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("hide")
    protected Boolean hide;

    @JsonProperty("path")
    protected String path;

    protected MacOSLaunchItem() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.macOSLaunchItem";
    }

    /**
     * <i>“Whether or not to hide the item from the Users and Groups List.”</i>
     * 
     * @return property hide
     */
    @Property(name="hide")
    @JsonIgnore
    public Optional<Boolean> getHide() {
        return Optional.ofNullable(hide);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code hide} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Whether or not to hide the item from the Users and Groups List.”</i>
     * 
     * @param hide
     *            new value of {@code hide} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code hide} field changed
     */
    public MacOSLaunchItem withHide(Boolean hide) {
        MacOSLaunchItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSLaunchItem");
        _x.hide = hide;
        return _x;
    }

    /**
     * <i>“Path to the launch item.”</i>
     * 
     * @return property path
     */
    @Property(name="path")
    @JsonIgnore
    public Optional<String> getPath() {
        return Optional.ofNullable(path);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code path} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Path to the launch item.”</i>
     * 
     * @param path
     *            new value of {@code path} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code path} field changed
     */
    public MacOSLaunchItem withPath(String path) {
        MacOSLaunchItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSLaunchItem");
        _x.path = path;
        return _x;
    }

    public MacOSLaunchItem withUnmappedField(String name, Object value) {
        MacOSLaunchItem _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean hide;
        private String path;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Whether or not to hide the item from the Users and Groups List.”</i>
         * 
         * @param hide
         *            value of {@code hide} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder hide(Boolean hide) {
            this.hide = hide;
            this.changedFields = changedFields.add("hide");
            return this;
        }

        /**
         * <i>“Path to the launch item.”</i>
         * 
         * @param path
         *            value of {@code path} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder path(String path) {
            this.path = path;
            this.changedFields = changedFields.add("path");
            return this;
        }

        public MacOSLaunchItem build() {
            MacOSLaunchItem _x = new MacOSLaunchItem();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.macOSLaunchItem";
            _x.hide = hide;
            _x.path = path;
            return _x;
        }
    }

    private MacOSLaunchItem _copy() {
        MacOSLaunchItem _x = new MacOSLaunchItem();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.hide = hide;
        _x.path = path;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MacOSLaunchItem[");
        b.append("hide=");
        b.append(this.hide);
        b.append(", ");
        b.append("path=");
        b.append(this.path);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
