package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "allowMultipleValues", 
    "allowUnlimitedLength", 
    "columnName", 
    "listId", 
    "primaryLookupColumnId"})
@JsonInclude(Include.NON_NULL)
public class LookupColumn implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("allowMultipleValues")
    protected Boolean allowMultipleValues;

    @JsonProperty("allowUnlimitedLength")
    protected Boolean allowUnlimitedLength;

    @JsonProperty("columnName")
    protected String columnName;

    @JsonProperty("listId")
    protected String listId;

    @JsonProperty("primaryLookupColumnId")
    protected String primaryLookupColumnId;

    protected LookupColumn() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.lookupColumn";
    }

    @Property(name="allowMultipleValues")
    @JsonIgnore
    public Optional<Boolean> getAllowMultipleValues() {
        return Optional.ofNullable(allowMultipleValues);
    }

    public LookupColumn withAllowMultipleValues(Boolean allowMultipleValues) {
        LookupColumn _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.lookupColumn");
        _x.allowMultipleValues = allowMultipleValues;
        return _x;
    }

    @Property(name="allowUnlimitedLength")
    @JsonIgnore
    public Optional<Boolean> getAllowUnlimitedLength() {
        return Optional.ofNullable(allowUnlimitedLength);
    }

    public LookupColumn withAllowUnlimitedLength(Boolean allowUnlimitedLength) {
        LookupColumn _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.lookupColumn");
        _x.allowUnlimitedLength = allowUnlimitedLength;
        return _x;
    }

    @Property(name="columnName")
    @JsonIgnore
    public Optional<String> getColumnName() {
        return Optional.ofNullable(columnName);
    }

    public LookupColumn withColumnName(String columnName) {
        LookupColumn _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.lookupColumn");
        _x.columnName = columnName;
        return _x;
    }

    @Property(name="listId")
    @JsonIgnore
    public Optional<String> getListId() {
        return Optional.ofNullable(listId);
    }

    public LookupColumn withListId(String listId) {
        LookupColumn _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.lookupColumn");
        _x.listId = listId;
        return _x;
    }

    @Property(name="primaryLookupColumnId")
    @JsonIgnore
    public Optional<String> getPrimaryLookupColumnId() {
        return Optional.ofNullable(primaryLookupColumnId);
    }

    public LookupColumn withPrimaryLookupColumnId(String primaryLookupColumnId) {
        LookupColumn _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.lookupColumn");
        _x.primaryLookupColumnId = primaryLookupColumnId;
        return _x;
    }

    public LookupColumn withUnmappedField(String name, Object value) {
        LookupColumn _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean allowMultipleValues;
        private Boolean allowUnlimitedLength;
        private String columnName;
        private String listId;
        private String primaryLookupColumnId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder allowMultipleValues(Boolean allowMultipleValues) {
            this.allowMultipleValues = allowMultipleValues;
            this.changedFields = changedFields.add("allowMultipleValues");
            return this;
        }

        public Builder allowUnlimitedLength(Boolean allowUnlimitedLength) {
            this.allowUnlimitedLength = allowUnlimitedLength;
            this.changedFields = changedFields.add("allowUnlimitedLength");
            return this;
        }

        public Builder columnName(String columnName) {
            this.columnName = columnName;
            this.changedFields = changedFields.add("columnName");
            return this;
        }

        public Builder listId(String listId) {
            this.listId = listId;
            this.changedFields = changedFields.add("listId");
            return this;
        }

        public Builder primaryLookupColumnId(String primaryLookupColumnId) {
            this.primaryLookupColumnId = primaryLookupColumnId;
            this.changedFields = changedFields.add("primaryLookupColumnId");
            return this;
        }

        public LookupColumn build() {
            LookupColumn _x = new LookupColumn();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.lookupColumn";
            _x.allowMultipleValues = allowMultipleValues;
            _x.allowUnlimitedLength = allowUnlimitedLength;
            _x.columnName = columnName;
            _x.listId = listId;
            _x.primaryLookupColumnId = primaryLookupColumnId;
            return _x;
        }
    }

    private LookupColumn _copy() {
        LookupColumn _x = new LookupColumn();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.allowMultipleValues = allowMultipleValues;
        _x.allowUnlimitedLength = allowUnlimitedLength;
        _x.columnName = columnName;
        _x.listId = listId;
        _x.primaryLookupColumnId = primaryLookupColumnId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LookupColumn[");
        b.append("allowMultipleValues=");
        b.append(this.allowMultipleValues);
        b.append(", ");
        b.append("allowUnlimitedLength=");
        b.append(this.allowUnlimitedLength);
        b.append(", ");
        b.append("columnName=");
        b.append(this.columnName);
        b.append(", ");
        b.append("listId=");
        b.append(this.listId);
        b.append(", ");
        b.append("primaryLookupColumnId=");
        b.append(this.primaryLookupColumnId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
