package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.LogonType;
import odata.msgraph.client.beta.enums.UserAccountSecurityType;

@JsonPropertyOrder({
    "@odata.type", 
    "accountDomain", 
    "accountName", 
    "accountType", 
    "firstSeenDateTime", 
    "lastSeenDateTime", 
    "logonId", 
    "logonTypes"})
@JsonInclude(Include.NON_NULL)
public class LogonUser implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("accountDomain")
    protected String accountDomain;

    @JsonProperty("accountName")
    protected String accountName;

    @JsonProperty("accountType")
    protected UserAccountSecurityType accountType;

    @JsonProperty("firstSeenDateTime")
    protected OffsetDateTime firstSeenDateTime;

    @JsonProperty("lastSeenDateTime")
    protected OffsetDateTime lastSeenDateTime;

    @JsonProperty("logonId")
    protected String logonId;

    @JsonProperty("logonTypes")
    protected List<LogonType> logonTypes;

    @JsonProperty("logonTypes@nextLink")
    protected String logonTypesNextLink;

    protected LogonUser() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.logonUser";
    }

    @Property(name="accountDomain")
    @JsonIgnore
    public Optional<String> getAccountDomain() {
        return Optional.ofNullable(accountDomain);
    }

    public LogonUser withAccountDomain(String accountDomain) {
        LogonUser _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.logonUser");
        _x.accountDomain = accountDomain;
        return _x;
    }

    @Property(name="accountName")
    @JsonIgnore
    public Optional<String> getAccountName() {
        return Optional.ofNullable(accountName);
    }

    public LogonUser withAccountName(String accountName) {
        LogonUser _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.logonUser");
        _x.accountName = accountName;
        return _x;
    }

    @Property(name="accountType")
    @JsonIgnore
    public Optional<UserAccountSecurityType> getAccountType() {
        return Optional.ofNullable(accountType);
    }

    public LogonUser withAccountType(UserAccountSecurityType accountType) {
        LogonUser _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.logonUser");
        _x.accountType = accountType;
        return _x;
    }

    @Property(name="firstSeenDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getFirstSeenDateTime() {
        return Optional.ofNullable(firstSeenDateTime);
    }

    public LogonUser withFirstSeenDateTime(OffsetDateTime firstSeenDateTime) {
        LogonUser _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.logonUser");
        _x.firstSeenDateTime = firstSeenDateTime;
        return _x;
    }

    @Property(name="lastSeenDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastSeenDateTime() {
        return Optional.ofNullable(lastSeenDateTime);
    }

    public LogonUser withLastSeenDateTime(OffsetDateTime lastSeenDateTime) {
        LogonUser _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.logonUser");
        _x.lastSeenDateTime = lastSeenDateTime;
        return _x;
    }

    @Property(name="logonId")
    @JsonIgnore
    public Optional<String> getLogonId() {
        return Optional.ofNullable(logonId);
    }

    public LogonUser withLogonId(String logonId) {
        LogonUser _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.logonUser");
        _x.logonId = logonId;
        return _x;
    }

    @Property(name="logonTypes")
    @JsonIgnore
    public CollectionPage<LogonType> getLogonTypes() {
        return new CollectionPage<LogonType>(contextPath, LogonType.class, this.logonTypes, Optional.ofNullable(logonTypesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="logonTypes")
    @JsonIgnore
    public CollectionPage<LogonType> getLogonTypes(HttpRequestOptions options) {
        return new CollectionPage<LogonType>(contextPath, LogonType.class, this.logonTypes, Optional.ofNullable(logonTypesNextLink), Collections.emptyList(), options);
    }

    public LogonUser withUnmappedField(String name, Object value) {
        LogonUser _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String accountDomain;
        private String accountName;
        private UserAccountSecurityType accountType;
        private OffsetDateTime firstSeenDateTime;
        private OffsetDateTime lastSeenDateTime;
        private String logonId;
        private List<LogonType> logonTypes;
        private String logonTypesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder accountDomain(String accountDomain) {
            this.accountDomain = accountDomain;
            this.changedFields = changedFields.add("accountDomain");
            return this;
        }

        public Builder accountName(String accountName) {
            this.accountName = accountName;
            this.changedFields = changedFields.add("accountName");
            return this;
        }

        public Builder accountType(UserAccountSecurityType accountType) {
            this.accountType = accountType;
            this.changedFields = changedFields.add("accountType");
            return this;
        }

        public Builder firstSeenDateTime(OffsetDateTime firstSeenDateTime) {
            this.firstSeenDateTime = firstSeenDateTime;
            this.changedFields = changedFields.add("firstSeenDateTime");
            return this;
        }

        public Builder lastSeenDateTime(OffsetDateTime lastSeenDateTime) {
            this.lastSeenDateTime = lastSeenDateTime;
            this.changedFields = changedFields.add("lastSeenDateTime");
            return this;
        }

        public Builder logonId(String logonId) {
            this.logonId = logonId;
            this.changedFields = changedFields.add("logonId");
            return this;
        }

        public Builder logonTypes(List<LogonType> logonTypes) {
            this.logonTypes = logonTypes;
            this.changedFields = changedFields.add("logonTypes");
            return this;
        }

        public Builder logonTypes(LogonType... logonTypes) {
            return logonTypes(Arrays.asList(logonTypes));
        }

        public Builder logonTypesNextLink(String logonTypesNextLink) {
            this.logonTypesNextLink = logonTypesNextLink;
            this.changedFields = changedFields.add("logonTypes");
            return this;
        }

        public LogonUser build() {
            LogonUser _x = new LogonUser();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.logonUser";
            _x.accountDomain = accountDomain;
            _x.accountName = accountName;
            _x.accountType = accountType;
            _x.firstSeenDateTime = firstSeenDateTime;
            _x.lastSeenDateTime = lastSeenDateTime;
            _x.logonId = logonId;
            _x.logonTypes = logonTypes;
            _x.logonTypesNextLink = logonTypesNextLink;
            return _x;
        }
    }

    private LogonUser _copy() {
        LogonUser _x = new LogonUser();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.accountDomain = accountDomain;
        _x.accountName = accountName;
        _x.accountType = accountType;
        _x.firstSeenDateTime = firstSeenDateTime;
        _x.lastSeenDateTime = lastSeenDateTime;
        _x.logonId = logonId;
        _x.logonTypes = logonTypes;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LogonUser[");
        b.append("accountDomain=");
        b.append(this.accountDomain);
        b.append(", ");
        b.append("accountName=");
        b.append(this.accountName);
        b.append(", ");
        b.append("accountType=");
        b.append(this.accountType);
        b.append(", ");
        b.append("firstSeenDateTime=");
        b.append(this.firstSeenDateTime);
        b.append(", ");
        b.append("lastSeenDateTime=");
        b.append(this.lastSeenDateTime);
        b.append(", ");
        b.append("logonId=");
        b.append(this.logonId);
        b.append(", ");
        b.append("logonTypes=");
        b.append(this.logonTypes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
