package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "hideCannotAccessYourAccount", 
    "hideForgotMyPassword", 
    "hidePrivacyAndCookies", 
    "hideResetItNow", 
    "hideTermsOfUse"})
@JsonInclude(Include.NON_NULL)
public class LoginPageTextVisibilitySettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("hideCannotAccessYourAccount")
    protected Boolean hideCannotAccessYourAccount;

    @JsonProperty("hideForgotMyPassword")
    protected Boolean hideForgotMyPassword;

    @JsonProperty("hidePrivacyAndCookies")
    protected Boolean hidePrivacyAndCookies;

    @JsonProperty("hideResetItNow")
    protected Boolean hideResetItNow;

    @JsonProperty("hideTermsOfUse")
    protected Boolean hideTermsOfUse;

    protected LoginPageTextVisibilitySettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.loginPageTextVisibilitySettings";
    }

    @Property(name="hideCannotAccessYourAccount")
    @JsonIgnore
    public Optional<Boolean> getHideCannotAccessYourAccount() {
        return Optional.ofNullable(hideCannotAccessYourAccount);
    }

    public LoginPageTextVisibilitySettings withHideCannotAccessYourAccount(Boolean hideCannotAccessYourAccount) {
        LoginPageTextVisibilitySettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.loginPageTextVisibilitySettings");
        _x.hideCannotAccessYourAccount = hideCannotAccessYourAccount;
        return _x;
    }

    @Property(name="hideForgotMyPassword")
    @JsonIgnore
    public Optional<Boolean> getHideForgotMyPassword() {
        return Optional.ofNullable(hideForgotMyPassword);
    }

    public LoginPageTextVisibilitySettings withHideForgotMyPassword(Boolean hideForgotMyPassword) {
        LoginPageTextVisibilitySettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.loginPageTextVisibilitySettings");
        _x.hideForgotMyPassword = hideForgotMyPassword;
        return _x;
    }

    @Property(name="hidePrivacyAndCookies")
    @JsonIgnore
    public Optional<Boolean> getHidePrivacyAndCookies() {
        return Optional.ofNullable(hidePrivacyAndCookies);
    }

    public LoginPageTextVisibilitySettings withHidePrivacyAndCookies(Boolean hidePrivacyAndCookies) {
        LoginPageTextVisibilitySettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.loginPageTextVisibilitySettings");
        _x.hidePrivacyAndCookies = hidePrivacyAndCookies;
        return _x;
    }

    @Property(name="hideResetItNow")
    @JsonIgnore
    public Optional<Boolean> getHideResetItNow() {
        return Optional.ofNullable(hideResetItNow);
    }

    public LoginPageTextVisibilitySettings withHideResetItNow(Boolean hideResetItNow) {
        LoginPageTextVisibilitySettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.loginPageTextVisibilitySettings");
        _x.hideResetItNow = hideResetItNow;
        return _x;
    }

    @Property(name="hideTermsOfUse")
    @JsonIgnore
    public Optional<Boolean> getHideTermsOfUse() {
        return Optional.ofNullable(hideTermsOfUse);
    }

    public LoginPageTextVisibilitySettings withHideTermsOfUse(Boolean hideTermsOfUse) {
        LoginPageTextVisibilitySettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.loginPageTextVisibilitySettings");
        _x.hideTermsOfUse = hideTermsOfUse;
        return _x;
    }

    public LoginPageTextVisibilitySettings withUnmappedField(String name, Object value) {
        LoginPageTextVisibilitySettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean hideCannotAccessYourAccount;
        private Boolean hideForgotMyPassword;
        private Boolean hidePrivacyAndCookies;
        private Boolean hideResetItNow;
        private Boolean hideTermsOfUse;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder hideCannotAccessYourAccount(Boolean hideCannotAccessYourAccount) {
            this.hideCannotAccessYourAccount = hideCannotAccessYourAccount;
            this.changedFields = changedFields.add("hideCannotAccessYourAccount");
            return this;
        }

        public Builder hideForgotMyPassword(Boolean hideForgotMyPassword) {
            this.hideForgotMyPassword = hideForgotMyPassword;
            this.changedFields = changedFields.add("hideForgotMyPassword");
            return this;
        }

        public Builder hidePrivacyAndCookies(Boolean hidePrivacyAndCookies) {
            this.hidePrivacyAndCookies = hidePrivacyAndCookies;
            this.changedFields = changedFields.add("hidePrivacyAndCookies");
            return this;
        }

        public Builder hideResetItNow(Boolean hideResetItNow) {
            this.hideResetItNow = hideResetItNow;
            this.changedFields = changedFields.add("hideResetItNow");
            return this;
        }

        public Builder hideTermsOfUse(Boolean hideTermsOfUse) {
            this.hideTermsOfUse = hideTermsOfUse;
            this.changedFields = changedFields.add("hideTermsOfUse");
            return this;
        }

        public LoginPageTextVisibilitySettings build() {
            LoginPageTextVisibilitySettings _x = new LoginPageTextVisibilitySettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.loginPageTextVisibilitySettings";
            _x.hideCannotAccessYourAccount = hideCannotAccessYourAccount;
            _x.hideForgotMyPassword = hideForgotMyPassword;
            _x.hidePrivacyAndCookies = hidePrivacyAndCookies;
            _x.hideResetItNow = hideResetItNow;
            _x.hideTermsOfUse = hideTermsOfUse;
            return _x;
        }
    }

    private LoginPageTextVisibilitySettings _copy() {
        LoginPageTextVisibilitySettings _x = new LoginPageTextVisibilitySettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.hideCannotAccessYourAccount = hideCannotAccessYourAccount;
        _x.hideForgotMyPassword = hideForgotMyPassword;
        _x.hidePrivacyAndCookies = hidePrivacyAndCookies;
        _x.hideResetItNow = hideResetItNow;
        _x.hideTermsOfUse = hideTermsOfUse;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LoginPageTextVisibilitySettings[");
        b.append("hideCannotAccessYourAccount=");
        b.append(this.hideCannotAccessYourAccount);
        b.append(", ");
        b.append("hideForgotMyPassword=");
        b.append(this.hideForgotMyPassword);
        b.append(", ");
        b.append("hidePrivacyAndCookies=");
        b.append(this.hidePrivacyAndCookies);
        b.append(", ");
        b.append("hideResetItNow=");
        b.append(this.hideResetItNow);
        b.append(", ");
        b.append("hideTermsOfUse=");
        b.append(this.hideTermsOfUse);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
