package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ActionState;


/**
 * <i>“Locate device action result”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deviceLocation"})
@JsonInclude(Include.NON_NULL)
public class LocateDeviceActionResult extends DeviceActionResult implements ODataType {

    @JsonProperty("deviceLocation")
    protected DeviceGeoLocation deviceLocation;

    protected LocateDeviceActionResult() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.locateDeviceActionResult";
    }

    /**
     * <i>“device location”</i>
     * 
     * @return property deviceLocation
     */
    @Property(name="deviceLocation")
    @JsonIgnore
    public Optional<DeviceGeoLocation> getDeviceLocation() {
        return Optional.ofNullable(deviceLocation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceLocation}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“device location”</i>
     * 
     * @param deviceLocation
     *            new value of {@code deviceLocation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceLocation} field changed
     */
    public LocateDeviceActionResult withDeviceLocation(DeviceGeoLocation deviceLocation) {
        LocateDeviceActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.locateDeviceActionResult");
        _x.deviceLocation = deviceLocation;
        return _x;
    }

    public LocateDeviceActionResult withUnmappedField(String name, Object value) {
        LocateDeviceActionResult _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderLocateDeviceActionResult() {
        return new Builder();
    }

    public static final class Builder {
        private String actionName;
        private ActionState actionState;
        private OffsetDateTime lastUpdatedDateTime;
        private OffsetDateTime startDateTime;
        private DeviceGeoLocation deviceLocation;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder actionName(String actionName) {
            this.actionName = actionName;
            this.changedFields = changedFields.add("actionName");
            return this;
        }

        public Builder actionState(ActionState actionState) {
            this.actionState = actionState;
            this.changedFields = changedFields.add("actionState");
            return this;
        }

        public Builder lastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            this.changedFields = changedFields.add("lastUpdatedDateTime");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        /**
         * <i>“device location”</i>
         * 
         * @param deviceLocation
         *            value of {@code deviceLocation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceLocation(DeviceGeoLocation deviceLocation) {
            this.deviceLocation = deviceLocation;
            this.changedFields = changedFields.add("deviceLocation");
            return this;
        }

        public LocateDeviceActionResult build() {
            LocateDeviceActionResult _x = new LocateDeviceActionResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.locateDeviceActionResult";
            _x.actionName = actionName;
            _x.actionState = actionState;
            _x.lastUpdatedDateTime = lastUpdatedDateTime;
            _x.startDateTime = startDateTime;
            _x.deviceLocation = deviceLocation;
            return _x;
        }
    }

    private LocateDeviceActionResult _copy() {
        LocateDeviceActionResult _x = new LocateDeviceActionResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.actionName = actionName;
        _x.actionState = actionState;
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        _x.startDateTime = startDateTime;
        _x.deviceLocation = deviceLocation;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LocateDeviceActionResult[");
        b.append("actionName=");
        b.append(this.actionName);
        b.append(", ");
        b.append("actionState=");
        b.append(this.actionState);
        b.append(", ");
        b.append("lastUpdatedDateTime=");
        b.append(this.lastUpdatedDateTime);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("deviceLocation=");
        b.append(this.deviceLocation);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
