package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Key long value pair”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "name", 
    "value"})
@JsonInclude(Include.NON_NULL)
public class KeyLongValuePair implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("value")
    protected Long value;

    protected KeyLongValuePair() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.keyLongValuePair";
    }

    /**
     * <i>“Name for this key long value pair”</i>
     * 
     * @return property name
     */
    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code name} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Name for this key long value pair”</i>
     * 
     * @param name
     *            new value of {@code name} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code name} field changed
     */
    public KeyLongValuePair withName(String name) {
        KeyLongValuePair _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.keyLongValuePair");
        _x.name = name;
        return _x;
    }

    /**
     * <i>“Value for this key long value pair”</i>
     * 
     * @return property value
     */
    @Property(name="value")
    @JsonIgnore
    public Optional<Long> getValue() {
        return Optional.ofNullable(value);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code value} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Value for this key long value pair”</i>
     * 
     * @param value
     *            new value of {@code value} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code value} field changed
     */
    public KeyLongValuePair withValue(Long value) {
        KeyLongValuePair _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.keyLongValuePair");
        _x.value = value;
        return _x;
    }

    public KeyLongValuePair withUnmappedField(String name, Object value) {
        KeyLongValuePair _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private Long value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Name for this key long value pair”</i>
         * 
         * @param name
         *            value of {@code name} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        /**
         * <i>“Value for this key long value pair”</i>
         * 
         * @param value
         *            value of {@code value} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder value(Long value) {
            this.value = value;
            this.changedFields = changedFields.add("value");
            return this;
        }

        public KeyLongValuePair build() {
            KeyLongValuePair _x = new KeyLongValuePair();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.keyLongValuePair";
            _x.name = name;
            _x.value = value;
            return _x;
        }
    }

    private KeyLongValuePair _copy() {
        KeyLongValuePair _x = new KeyLongValuePair();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.name = name;
        _x.value = value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("KeyLongValuePair[");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("value=");
        b.append(this.value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
