package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "isPasscodeRequired", 
    "joinMeetingId", 
    "passcode"})
@JsonInclude(Include.NON_NULL)
public class JoinMeetingIdSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("isPasscodeRequired")
    protected Boolean isPasscodeRequired;

    @JsonProperty("joinMeetingId")
    protected String joinMeetingId;

    @JsonProperty("passcode")
    protected String passcode;

    protected JoinMeetingIdSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.joinMeetingIdSettings";
    }

    @Property(name="isPasscodeRequired")
    @JsonIgnore
    public Optional<Boolean> getIsPasscodeRequired() {
        return Optional.ofNullable(isPasscodeRequired);
    }

    public JoinMeetingIdSettings withIsPasscodeRequired(Boolean isPasscodeRequired) {
        JoinMeetingIdSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.joinMeetingIdSettings");
        _x.isPasscodeRequired = isPasscodeRequired;
        return _x;
    }

    @Property(name="joinMeetingId")
    @JsonIgnore
    public Optional<String> getJoinMeetingId() {
        return Optional.ofNullable(joinMeetingId);
    }

    public JoinMeetingIdSettings withJoinMeetingId(String joinMeetingId) {
        JoinMeetingIdSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.joinMeetingIdSettings");
        _x.joinMeetingId = joinMeetingId;
        return _x;
    }

    @Property(name="passcode")
    @JsonIgnore
    public Optional<String> getPasscode() {
        return Optional.ofNullable(passcode);
    }

    public JoinMeetingIdSettings withPasscode(String passcode) {
        JoinMeetingIdSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.joinMeetingIdSettings");
        _x.passcode = passcode;
        return _x;
    }

    public JoinMeetingIdSettings withUnmappedField(String name, Object value) {
        JoinMeetingIdSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isPasscodeRequired;
        private String joinMeetingId;
        private String passcode;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder isPasscodeRequired(Boolean isPasscodeRequired) {
            this.isPasscodeRequired = isPasscodeRequired;
            this.changedFields = changedFields.add("isPasscodeRequired");
            return this;
        }

        public Builder joinMeetingId(String joinMeetingId) {
            this.joinMeetingId = joinMeetingId;
            this.changedFields = changedFields.add("joinMeetingId");
            return this;
        }

        public Builder passcode(String passcode) {
            this.passcode = passcode;
            this.changedFields = changedFields.add("passcode");
            return this;
        }

        public JoinMeetingIdSettings build() {
            JoinMeetingIdSettings _x = new JoinMeetingIdSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.joinMeetingIdSettings";
            _x.isPasscodeRequired = isPasscodeRequired;
            _x.joinMeetingId = joinMeetingId;
            _x.passcode = passcode;
            return _x;
        }
    }

    private JoinMeetingIdSettings _copy() {
        JoinMeetingIdSettings _x = new JoinMeetingIdSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.isPasscodeRequired = isPasscodeRequired;
        _x.joinMeetingId = joinMeetingId;
        _x.passcode = passcode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("JoinMeetingIdSettings[");
        b.append("isPasscodeRequired=");
        b.append(this.isPasscodeRequired);
        b.append(", ");
        b.append("joinMeetingId=");
        b.append(this.joinMeetingId);
        b.append(", ");
        b.append("passcode=");
        b.append(this.passcode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
