package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "actionCount", 
    "actorCount"})
@JsonInclude(Include.NON_NULL)
public class ItemActionStat implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("actionCount")
    protected Integer actionCount;

    @JsonProperty("actorCount")
    protected Integer actorCount;

    protected ItemActionStat() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.itemActionStat";
    }

    @Property(name="actionCount")
    @JsonIgnore
    public Optional<Integer> getActionCount() {
        return Optional.ofNullable(actionCount);
    }

    public ItemActionStat withActionCount(Integer actionCount) {
        ItemActionStat _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemActionStat");
        _x.actionCount = actionCount;
        return _x;
    }

    @Property(name="actorCount")
    @JsonIgnore
    public Optional<Integer> getActorCount() {
        return Optional.ofNullable(actorCount);
    }

    public ItemActionStat withActorCount(Integer actorCount) {
        ItemActionStat _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemActionStat");
        _x.actorCount = actorCount;
        return _x;
    }

    public ItemActionStat withUnmappedField(String name, Object value) {
        ItemActionStat _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer actionCount;
        private Integer actorCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder actionCount(Integer actionCount) {
            this.actionCount = actionCount;
            this.changedFields = changedFields.add("actionCount");
            return this;
        }

        public Builder actorCount(Integer actorCount) {
            this.actorCount = actorCount;
            this.changedFields = changedFields.add("actorCount");
            return this;
        }

        public ItemActionStat build() {
            ItemActionStat _x = new ItemActionStat();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.itemActionStat";
            _x.actionCount = actionCount;
            _x.actorCount = actorCount;
            return _x;
        }
    }

    private ItemActionStat _copy() {
        ItemActionStat _x = new ItemActionStat();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.actionCount = actionCount;
        _x.actorCount = actorCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ItemActionStat[");
        b.append("actionCount=");
        b.append(this.actionCount);
        b.append(", ");
        b.append("actorCount=");
        b.append(this.actorCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
