package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Represents an iOS Web Content Filter setting type, which installs URL bookmarks
 * into iOS built-in browser. An example scenario is in the classroom where
 * teachers would like the students to navigate websites through browser bookmarks
 * configured on their iOS devices, and no access to other sites.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "specificWebsitesOnly", 
    "websiteList"})
@JsonInclude(Include.NON_NULL)
public class IosWebContentFilterSpecificWebsitesAccess extends IosWebContentFilterBase implements ODataType {

    @JsonProperty("specificWebsitesOnly")
    protected List<IosBookmark> specificWebsitesOnly;

    @JsonProperty("specificWebsitesOnly@nextLink")
    protected String specificWebsitesOnlyNextLink;

    @JsonProperty("websiteList")
    protected List<IosBookmark> websiteList;

    @JsonProperty("websiteList@nextLink")
    protected String websiteListNextLink;

    protected IosWebContentFilterSpecificWebsitesAccess() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosWebContentFilterSpecificWebsitesAccess";
    }

    /**
     * <i>“URL bookmarks which will be installed into built-in browser and user is only
     * allowed to access websites through bookmarks. This collection can contain a
     * maximum of 500 elements.”</i>
     * 
     * @return property specificWebsitesOnly
     */
    @Property(name="specificWebsitesOnly")
    @JsonIgnore
    public CollectionPage<IosBookmark> getSpecificWebsitesOnly() {
        return new CollectionPage<IosBookmark>(contextPath, IosBookmark.class, this.specificWebsitesOnly, Optional.ofNullable(specificWebsitesOnlyNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“URL bookmarks which will be installed into built-in browser and user is only
     * allowed to access websites through bookmarks. This collection can contain a
     * maximum of 500 elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property specificWebsitesOnly
     */
    @Property(name="specificWebsitesOnly")
    @JsonIgnore
    public CollectionPage<IosBookmark> getSpecificWebsitesOnly(HttpRequestOptions options) {
        return new CollectionPage<IosBookmark>(contextPath, IosBookmark.class, this.specificWebsitesOnly, Optional.ofNullable(specificWebsitesOnlyNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“URL bookmarks which will be installed into built-in browser and user is only
     * allowed to access websites through bookmarks. This collection can contain a
     * maximum of 500 elements.”</i>
     * 
     * @return property websiteList
     */
    @Property(name="websiteList")
    @JsonIgnore
    public CollectionPage<IosBookmark> getWebsiteList() {
        return new CollectionPage<IosBookmark>(contextPath, IosBookmark.class, this.websiteList, Optional.ofNullable(websiteListNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“URL bookmarks which will be installed into built-in browser and user is only
     * allowed to access websites through bookmarks. This collection can contain a
     * maximum of 500 elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property websiteList
     */
    @Property(name="websiteList")
    @JsonIgnore
    public CollectionPage<IosBookmark> getWebsiteList(HttpRequestOptions options) {
        return new CollectionPage<IosBookmark>(contextPath, IosBookmark.class, this.websiteList, Optional.ofNullable(websiteListNextLink), Collections.emptyList(), options);
    }

    public IosWebContentFilterSpecificWebsitesAccess withUnmappedField(String name, Object value) {
        IosWebContentFilterSpecificWebsitesAccess _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderIosWebContentFilterSpecificWebsitesAccess() {
        return new Builder();
    }

    public static final class Builder {
        private List<IosBookmark> specificWebsitesOnly;
        private String specificWebsitesOnlyNextLink;
        private List<IosBookmark> websiteList;
        private String websiteListNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“URL bookmarks which will be installed into built-in browser and user is only
         * allowed to access websites through bookmarks. This collection can contain a
         * maximum of 500 elements.”</i>
         * 
         * @param specificWebsitesOnly
         *            value of {@code specificWebsitesOnly} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder specificWebsitesOnly(List<IosBookmark> specificWebsitesOnly) {
            this.specificWebsitesOnly = specificWebsitesOnly;
            this.changedFields = changedFields.add("specificWebsitesOnly");
            return this;
        }

        /**
         * <i>“URL bookmarks which will be installed into built-in browser and user is only
         * allowed to access websites through bookmarks. This collection can contain a
         * maximum of 500 elements.”</i>
         * 
         * @param specificWebsitesOnly
         *            value of {@code specificWebsitesOnly} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder specificWebsitesOnly(IosBookmark... specificWebsitesOnly) {
            return specificWebsitesOnly(Arrays.asList(specificWebsitesOnly));
        }

        /**
         * <i>“URL bookmarks which will be installed into built-in browser and user is only
         * allowed to access websites through bookmarks. This collection can contain a
         * maximum of 500 elements.”</i>
         * 
         * @param specificWebsitesOnlyNextLink
         *            value of {@code specificWebsitesOnly@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder specificWebsitesOnlyNextLink(String specificWebsitesOnlyNextLink) {
            this.specificWebsitesOnlyNextLink = specificWebsitesOnlyNextLink;
            this.changedFields = changedFields.add("specificWebsitesOnly");
            return this;
        }

        /**
         * <i>“URL bookmarks which will be installed into built-in browser and user is only
         * allowed to access websites through bookmarks. This collection can contain a
         * maximum of 500 elements.”</i>
         * 
         * @param websiteList
         *            value of {@code websiteList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder websiteList(List<IosBookmark> websiteList) {
            this.websiteList = websiteList;
            this.changedFields = changedFields.add("websiteList");
            return this;
        }

        /**
         * <i>“URL bookmarks which will be installed into built-in browser and user is only
         * allowed to access websites through bookmarks. This collection can contain a
         * maximum of 500 elements.”</i>
         * 
         * @param websiteList
         *            value of {@code websiteList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder websiteList(IosBookmark... websiteList) {
            return websiteList(Arrays.asList(websiteList));
        }

        /**
         * <i>“URL bookmarks which will be installed into built-in browser and user is only
         * allowed to access websites through bookmarks. This collection can contain a
         * maximum of 500 elements.”</i>
         * 
         * @param websiteListNextLink
         *            value of {@code websiteList@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder websiteListNextLink(String websiteListNextLink) {
            this.websiteListNextLink = websiteListNextLink;
            this.changedFields = changedFields.add("websiteList");
            return this;
        }

        public IosWebContentFilterSpecificWebsitesAccess build() {
            IosWebContentFilterSpecificWebsitesAccess _x = new IosWebContentFilterSpecificWebsitesAccess();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.iosWebContentFilterSpecificWebsitesAccess";
            _x.specificWebsitesOnly = specificWebsitesOnly;
            _x.specificWebsitesOnlyNextLink = specificWebsitesOnlyNextLink;
            _x.websiteList = websiteList;
            _x.websiteListNextLink = websiteListNextLink;
            return _x;
        }
    }

    private IosWebContentFilterSpecificWebsitesAccess _copy() {
        IosWebContentFilterSpecificWebsitesAccess _x = new IosWebContentFilterSpecificWebsitesAccess();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.specificWebsitesOnly = specificWebsitesOnly;
        _x.websiteList = websiteList;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosWebContentFilterSpecificWebsitesAccess[");
        b.append("specificWebsitesOnly=");
        b.append(this.specificWebsitesOnly);
        b.append(", ");
        b.append("websiteList=");
        b.append(this.websiteList);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
