package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.VpnEncryptionAlgorithmType;
import odata.msgraph.client.beta.enums.VpnIntegrityAlgorithmType;


/**
 * <i>“VPN Security Association Parameters”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "lifetimeInMinutes", 
    "securityDiffieHellmanGroup", 
    "securityEncryptionAlgorithm", 
    "securityIntegrityAlgorithm"})
@JsonInclude(Include.NON_NULL)
public class IosVpnSecurityAssociationParameters implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("lifetimeInMinutes")
    protected Integer lifetimeInMinutes;

    @JsonProperty("securityDiffieHellmanGroup")
    protected Integer securityDiffieHellmanGroup;

    @JsonProperty("securityEncryptionAlgorithm")
    protected VpnEncryptionAlgorithmType securityEncryptionAlgorithm;

    @JsonProperty("securityIntegrityAlgorithm")
    protected VpnIntegrityAlgorithmType securityIntegrityAlgorithm;

    protected IosVpnSecurityAssociationParameters() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosVpnSecurityAssociationParameters";
    }

    /**
     * <i>“Lifetime (minutes)”</i>
     * 
     * @return property lifetimeInMinutes
     */
    @Property(name="lifetimeInMinutes")
    @JsonIgnore
    public Optional<Integer> getLifetimeInMinutes() {
        return Optional.ofNullable(lifetimeInMinutes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code lifetimeInMinutes
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Lifetime (minutes)”</i>
     * 
     * @param lifetimeInMinutes
     *            new value of {@code lifetimeInMinutes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lifetimeInMinutes} field changed
     */
    public IosVpnSecurityAssociationParameters withLifetimeInMinutes(Integer lifetimeInMinutes) {
        IosVpnSecurityAssociationParameters _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosVpnSecurityAssociationParameters");
        _x.lifetimeInMinutes = lifetimeInMinutes;
        return _x;
    }

    /**
     * <i>“Diffie-Hellman Group”</i>
     * 
     * @return property securityDiffieHellmanGroup
     */
    @Property(name="securityDiffieHellmanGroup")
    @JsonIgnore
    public Optional<Integer> getSecurityDiffieHellmanGroup() {
        return Optional.ofNullable(securityDiffieHellmanGroup);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * securityDiffieHellmanGroup} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Diffie-Hellman Group”</i>
     * 
     * @param securityDiffieHellmanGroup
     *            new value of {@code securityDiffieHellmanGroup} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code securityDiffieHellmanGroup} field changed
     */
    public IosVpnSecurityAssociationParameters withSecurityDiffieHellmanGroup(Integer securityDiffieHellmanGroup) {
        IosVpnSecurityAssociationParameters _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosVpnSecurityAssociationParameters");
        _x.securityDiffieHellmanGroup = securityDiffieHellmanGroup;
        return _x;
    }

    /**
     * <i>“Encryption algorithm”</i>
     * 
     * @return property securityEncryptionAlgorithm
     */
    @Property(name="securityEncryptionAlgorithm")
    @JsonIgnore
    public Optional<VpnEncryptionAlgorithmType> getSecurityEncryptionAlgorithm() {
        return Optional.ofNullable(securityEncryptionAlgorithm);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * securityEncryptionAlgorithm} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Encryption algorithm”</i>
     * 
     * @param securityEncryptionAlgorithm
     *            new value of {@code securityEncryptionAlgorithm} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code securityEncryptionAlgorithm} field changed
     */
    public IosVpnSecurityAssociationParameters withSecurityEncryptionAlgorithm(VpnEncryptionAlgorithmType securityEncryptionAlgorithm) {
        IosVpnSecurityAssociationParameters _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosVpnSecurityAssociationParameters");
        _x.securityEncryptionAlgorithm = securityEncryptionAlgorithm;
        return _x;
    }

    /**
     * <i>“Integrity algorithm”</i>
     * 
     * @return property securityIntegrityAlgorithm
     */
    @Property(name="securityIntegrityAlgorithm")
    @JsonIgnore
    public Optional<VpnIntegrityAlgorithmType> getSecurityIntegrityAlgorithm() {
        return Optional.ofNullable(securityIntegrityAlgorithm);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * securityIntegrityAlgorithm} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Integrity algorithm”</i>
     * 
     * @param securityIntegrityAlgorithm
     *            new value of {@code securityIntegrityAlgorithm} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code securityIntegrityAlgorithm} field changed
     */
    public IosVpnSecurityAssociationParameters withSecurityIntegrityAlgorithm(VpnIntegrityAlgorithmType securityIntegrityAlgorithm) {
        IosVpnSecurityAssociationParameters _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosVpnSecurityAssociationParameters");
        _x.securityIntegrityAlgorithm = securityIntegrityAlgorithm;
        return _x;
    }

    public IosVpnSecurityAssociationParameters withUnmappedField(String name, Object value) {
        IosVpnSecurityAssociationParameters _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer lifetimeInMinutes;
        private Integer securityDiffieHellmanGroup;
        private VpnEncryptionAlgorithmType securityEncryptionAlgorithm;
        private VpnIntegrityAlgorithmType securityIntegrityAlgorithm;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Lifetime (minutes)”</i>
         * 
         * @param lifetimeInMinutes
         *            value of {@code lifetimeInMinutes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lifetimeInMinutes(Integer lifetimeInMinutes) {
            this.lifetimeInMinutes = lifetimeInMinutes;
            this.changedFields = changedFields.add("lifetimeInMinutes");
            return this;
        }

        /**
         * <i>“Diffie-Hellman Group”</i>
         * 
         * @param securityDiffieHellmanGroup
         *            value of {@code securityDiffieHellmanGroup} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder securityDiffieHellmanGroup(Integer securityDiffieHellmanGroup) {
            this.securityDiffieHellmanGroup = securityDiffieHellmanGroup;
            this.changedFields = changedFields.add("securityDiffieHellmanGroup");
            return this;
        }

        /**
         * <i>“Encryption algorithm”</i>
         * 
         * @param securityEncryptionAlgorithm
         *            value of {@code securityEncryptionAlgorithm} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder securityEncryptionAlgorithm(VpnEncryptionAlgorithmType securityEncryptionAlgorithm) {
            this.securityEncryptionAlgorithm = securityEncryptionAlgorithm;
            this.changedFields = changedFields.add("securityEncryptionAlgorithm");
            return this;
        }

        /**
         * <i>“Integrity algorithm”</i>
         * 
         * @param securityIntegrityAlgorithm
         *            value of {@code securityIntegrityAlgorithm} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder securityIntegrityAlgorithm(VpnIntegrityAlgorithmType securityIntegrityAlgorithm) {
            this.securityIntegrityAlgorithm = securityIntegrityAlgorithm;
            this.changedFields = changedFields.add("securityIntegrityAlgorithm");
            return this;
        }

        public IosVpnSecurityAssociationParameters build() {
            IosVpnSecurityAssociationParameters _x = new IosVpnSecurityAssociationParameters();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.iosVpnSecurityAssociationParameters";
            _x.lifetimeInMinutes = lifetimeInMinutes;
            _x.securityDiffieHellmanGroup = securityDiffieHellmanGroup;
            _x.securityEncryptionAlgorithm = securityEncryptionAlgorithm;
            _x.securityIntegrityAlgorithm = securityIntegrityAlgorithm;
            return _x;
        }
    }

    private IosVpnSecurityAssociationParameters _copy() {
        IosVpnSecurityAssociationParameters _x = new IosVpnSecurityAssociationParameters();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.lifetimeInMinutes = lifetimeInMinutes;
        _x.securityDiffieHellmanGroup = securityDiffieHellmanGroup;
        _x.securityEncryptionAlgorithm = securityEncryptionAlgorithm;
        _x.securityIntegrityAlgorithm = securityIntegrityAlgorithm;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosVpnSecurityAssociationParameters[");
        b.append("lifetimeInMinutes=");
        b.append(this.lifetimeInMinutes);
        b.append(", ");
        b.append("securityDiffieHellmanGroup=");
        b.append(this.securityDiffieHellmanGroup);
        b.append(", ");
        b.append("securityEncryptionAlgorithm=");
        b.append(this.securityEncryptionAlgorithm);
        b.append(", ");
        b.append("securityIntegrityAlgorithm=");
        b.append(this.securityIntegrityAlgorithm);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
