package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“iOS Kerberos authentication settings for single sign-on”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "allowedAppsList", 
    "allowedUrls", 
    "displayName", 
    "kerberosPrincipalName", 
    "kerberosRealm"})
@JsonInclude(Include.NON_NULL)
public class IosSingleSignOnSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("allowedAppsList")
    protected List<AppListItem> allowedAppsList;

    @JsonProperty("allowedAppsList@nextLink")
    protected String allowedAppsListNextLink;

    @JsonProperty("allowedUrls")
    protected List<String> allowedUrls;

    @JsonProperty("allowedUrls@nextLink")
    protected String allowedUrlsNextLink;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("kerberosPrincipalName")
    protected String kerberosPrincipalName;

    @JsonProperty("kerberosRealm")
    protected String kerberosRealm;

    protected IosSingleSignOnSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosSingleSignOnSettings";
    }

    /**
     * <i>“List of app identifiers that are allowed to use this login. If this field is
     * omitted, the login applies to all applications on the device. This collection
     * can contain a maximum of 500 elements.”</i>
     * 
     * @return property allowedAppsList
     */
    @Property(name="allowedAppsList")
    @JsonIgnore
    public CollectionPage<AppListItem> getAllowedAppsList() {
        return new CollectionPage<AppListItem>(contextPath, AppListItem.class, this.allowedAppsList, Optional.ofNullable(allowedAppsListNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of app identifiers that are allowed to use this login. If this field is
     * omitted, the login applies to all applications on the device. This collection
     * can contain a maximum of 500 elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property allowedAppsList
     */
    @Property(name="allowedAppsList")
    @JsonIgnore
    public CollectionPage<AppListItem> getAllowedAppsList(HttpRequestOptions options) {
        return new CollectionPage<AppListItem>(contextPath, AppListItem.class, this.allowedAppsList, Optional.ofNullable(allowedAppsListNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“List of HTTP URLs that must be matched in order to use this login. With iOS 9.0
     * or later, a wildcard characters may be used.”</i>
     * 
     * @return property allowedUrls
     */
    @Property(name="allowedUrls")
    @JsonIgnore
    public CollectionPage<String> getAllowedUrls() {
        return new CollectionPage<String>(contextPath, String.class, this.allowedUrls, Optional.ofNullable(allowedUrlsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of HTTP URLs that must be matched in order to use this login. With iOS 9.0
     * or later, a wildcard characters may be used.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property allowedUrls
     */
    @Property(name="allowedUrls")
    @JsonIgnore
    public CollectionPage<String> getAllowedUrls(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.allowedUrls, Optional.ofNullable(allowedUrlsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The display name of login settings shown on the receiving device.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The display name of login settings shown on the receiving device.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public IosSingleSignOnSettings withDisplayName(String displayName) {
        IosSingleSignOnSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosSingleSignOnSettings");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“A Kerberos principal name. If not provided, the user is prompted for one during
     * profile installation.”</i>
     * 
     * @return property kerberosPrincipalName
     */
    @Property(name="kerberosPrincipalName")
    @JsonIgnore
    public Optional<String> getKerberosPrincipalName() {
        return Optional.ofNullable(kerberosPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kerberosPrincipalName} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“A Kerberos principal name. If not provided, the user is prompted for one during
     * profile installation.”</i>
     * 
     * @param kerberosPrincipalName
     *            new value of {@code kerberosPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kerberosPrincipalName} field changed
     */
    public IosSingleSignOnSettings withKerberosPrincipalName(String kerberosPrincipalName) {
        IosSingleSignOnSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosSingleSignOnSettings");
        _x.kerberosPrincipalName = kerberosPrincipalName;
        return _x;
    }

    /**
     * <i>“A Kerberos realm name. Case sensitive.”</i>
     * 
     * @return property kerberosRealm
     */
    @Property(name="kerberosRealm")
    @JsonIgnore
    public Optional<String> getKerberosRealm() {
        return Optional.ofNullable(kerberosRealm);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code kerberosRealm}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“A Kerberos realm name. Case sensitive.”</i>
     * 
     * @param kerberosRealm
     *            new value of {@code kerberosRealm} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kerberosRealm} field changed
     */
    public IosSingleSignOnSettings withKerberosRealm(String kerberosRealm) {
        IosSingleSignOnSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosSingleSignOnSettings");
        _x.kerberosRealm = kerberosRealm;
        return _x;
    }

    public IosSingleSignOnSettings withUnmappedField(String name, Object value) {
        IosSingleSignOnSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<AppListItem> allowedAppsList;
        private String allowedAppsListNextLink;
        private List<String> allowedUrls;
        private String allowedUrlsNextLink;
        private String displayName;
        private String kerberosPrincipalName;
        private String kerberosRealm;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“List of app identifiers that are allowed to use this login. If this field is
         * omitted, the login applies to all applications on the device. This collection
         * can contain a maximum of 500 elements.”</i>
         * 
         * @param allowedAppsList
         *            value of {@code allowedAppsList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedAppsList(List<AppListItem> allowedAppsList) {
            this.allowedAppsList = allowedAppsList;
            this.changedFields = changedFields.add("allowedAppsList");
            return this;
        }

        /**
         * <i>“List of app identifiers that are allowed to use this login. If this field is
         * omitted, the login applies to all applications on the device. This collection
         * can contain a maximum of 500 elements.”</i>
         * 
         * @param allowedAppsList
         *            value of {@code allowedAppsList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedAppsList(AppListItem... allowedAppsList) {
            return allowedAppsList(Arrays.asList(allowedAppsList));
        }

        /**
         * <i>“List of app identifiers that are allowed to use this login. If this field is
         * omitted, the login applies to all applications on the device. This collection
         * can contain a maximum of 500 elements.”</i>
         * 
         * @param allowedAppsListNextLink
         *            value of {@code allowedAppsList@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedAppsListNextLink(String allowedAppsListNextLink) {
            this.allowedAppsListNextLink = allowedAppsListNextLink;
            this.changedFields = changedFields.add("allowedAppsList");
            return this;
        }

        /**
         * <i>“List of HTTP URLs that must be matched in order to use this login. With iOS 9.0
         * or later, a wildcard characters may be used.”</i>
         * 
         * @param allowedUrls
         *            value of {@code allowedUrls} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedUrls(List<String> allowedUrls) {
            this.allowedUrls = allowedUrls;
            this.changedFields = changedFields.add("allowedUrls");
            return this;
        }

        /**
         * <i>“List of HTTP URLs that must be matched in order to use this login. With iOS 9.0
         * or later, a wildcard characters may be used.”</i>
         * 
         * @param allowedUrls
         *            value of {@code allowedUrls} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedUrls(String... allowedUrls) {
            return allowedUrls(Arrays.asList(allowedUrls));
        }

        /**
         * <i>“List of HTTP URLs that must be matched in order to use this login. With iOS 9.0
         * or later, a wildcard characters may be used.”</i>
         * 
         * @param allowedUrlsNextLink
         *            value of {@code allowedUrls@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedUrlsNextLink(String allowedUrlsNextLink) {
            this.allowedUrlsNextLink = allowedUrlsNextLink;
            this.changedFields = changedFields.add("allowedUrls");
            return this;
        }

        /**
         * <i>“The display name of login settings shown on the receiving device.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“A Kerberos principal name. If not provided, the user is prompted for one during
         * profile installation.”</i>
         * 
         * @param kerberosPrincipalName
         *            value of {@code kerberosPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kerberosPrincipalName(String kerberosPrincipalName) {
            this.kerberosPrincipalName = kerberosPrincipalName;
            this.changedFields = changedFields.add("kerberosPrincipalName");
            return this;
        }

        /**
         * <i>“A Kerberos realm name. Case sensitive.”</i>
         * 
         * @param kerberosRealm
         *            value of {@code kerberosRealm} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kerberosRealm(String kerberosRealm) {
            this.kerberosRealm = kerberosRealm;
            this.changedFields = changedFields.add("kerberosRealm");
            return this;
        }

        public IosSingleSignOnSettings build() {
            IosSingleSignOnSettings _x = new IosSingleSignOnSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.iosSingleSignOnSettings";
            _x.allowedAppsList = allowedAppsList;
            _x.allowedAppsListNextLink = allowedAppsListNextLink;
            _x.allowedUrls = allowedUrls;
            _x.allowedUrlsNextLink = allowedUrlsNextLink;
            _x.displayName = displayName;
            _x.kerberosPrincipalName = kerberosPrincipalName;
            _x.kerberosRealm = kerberosRealm;
            return _x;
        }
    }

    private IosSingleSignOnSettings _copy() {
        IosSingleSignOnSettings _x = new IosSingleSignOnSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.allowedAppsList = allowedAppsList;
        _x.allowedUrls = allowedUrls;
        _x.displayName = displayName;
        _x.kerberosPrincipalName = kerberosPrincipalName;
        _x.kerberosRealm = kerberosRealm;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosSingleSignOnSettings[");
        b.append("allowedAppsList=");
        b.append(this.allowedAppsList);
        b.append(", ");
        b.append("allowedUrls=");
        b.append(this.allowedUrls);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("kerberosPrincipalName=");
        b.append(this.kerberosPrincipalName);
        b.append(", ");
        b.append("kerberosRealm=");
        b.append(this.kerberosRealm);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
