package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.IosNotificationAlertType;
import odata.msgraph.client.beta.enums.IosNotificationPreviewVisibility;


/**
 * <i>“An item describing notification setting.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "alertType", 
    "appName", 
    "badgesEnabled", 
    "bundleID", 
    "enabled", 
    "previewVisibility", 
    "publisher", 
    "showInNotificationCenter", 
    "showOnLockScreen", 
    "soundsEnabled"})
@JsonInclude(Include.NON_NULL)
public class IosNotificationSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("alertType")
    protected IosNotificationAlertType alertType;

    @JsonProperty("appName")
    protected String appName;

    @JsonProperty("badgesEnabled")
    protected Boolean badgesEnabled;

    @JsonProperty("bundleID")
    protected String bundleID;

    @JsonProperty("enabled")
    protected Boolean enabled;

    @JsonProperty("previewVisibility")
    protected IosNotificationPreviewVisibility previewVisibility;

    @JsonProperty("publisher")
    protected String publisher;

    @JsonProperty("showInNotificationCenter")
    protected Boolean showInNotificationCenter;

    @JsonProperty("showOnLockScreen")
    protected Boolean showOnLockScreen;

    @JsonProperty("soundsEnabled")
    protected Boolean soundsEnabled;

    protected IosNotificationSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosNotificationSettings";
    }

    /**
     * <i>“Indicates the type of alert for notifications for this app.”</i>
     * 
     * @return property alertType
     */
    @Property(name="alertType")
    @JsonIgnore
    public Optional<IosNotificationAlertType> getAlertType() {
        return Optional.ofNullable(alertType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code alertType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Indicates the type of alert for notifications for this app.”</i>
     * 
     * @param alertType
     *            new value of {@code alertType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code alertType} field changed
     */
    public IosNotificationSettings withAlertType(IosNotificationAlertType alertType) {
        IosNotificationSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosNotificationSettings");
        _x.alertType = alertType;
        return _x;
    }

    /**
     * <i>“Application name to be associated with the bundleID.”</i>
     * 
     * @return property appName
     */
    @Property(name="appName")
    @JsonIgnore
    public Optional<String> getAppName() {
        return Optional.ofNullable(appName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Application name to be associated with the bundleID.”</i>
     * 
     * @param appName
     *            new value of {@code appName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appName} field changed
     */
    public IosNotificationSettings withAppName(String appName) {
        IosNotificationSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosNotificationSettings");
        _x.appName = appName;
        return _x;
    }

    /**
     * <i>“Indicates whether badges are allowed for this app.”</i>
     * 
     * @return property badgesEnabled
     */
    @Property(name="badgesEnabled")
    @JsonIgnore
    public Optional<Boolean> getBadgesEnabled() {
        return Optional.ofNullable(badgesEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code badgesEnabled}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether badges are allowed for this app.”</i>
     * 
     * @param badgesEnabled
     *            new value of {@code badgesEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code badgesEnabled} field changed
     */
    public IosNotificationSettings withBadgesEnabled(Boolean badgesEnabled) {
        IosNotificationSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosNotificationSettings");
        _x.badgesEnabled = badgesEnabled;
        return _x;
    }

    /**
     * <i>“Bundle id of app to which to apply these notification settings.”</i>
     * 
     * @return property bundleID
     */
    @Property(name="bundleID")
    @JsonIgnore
    public Optional<String> getBundleID() {
        return Optional.ofNullable(bundleID);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code bundleID} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Bundle id of app to which to apply these notification settings.”</i>
     * 
     * @param bundleID
     *            new value of {@code bundleID} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bundleID} field changed
     */
    public IosNotificationSettings withBundleID(String bundleID) {
        IosNotificationSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosNotificationSettings");
        _x.bundleID = bundleID;
        return _x;
    }

    /**
     * <i>“Indicates whether notifications are allowed for this app.”</i>
     * 
     * @return property enabled
     */
    @Property(name="enabled")
    @JsonIgnore
    public Optional<Boolean> getEnabled() {
        return Optional.ofNullable(enabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code enabled} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Indicates whether notifications are allowed for this app.”</i>
     * 
     * @param enabled
     *            new value of {@code enabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enabled} field changed
     */
    public IosNotificationSettings withEnabled(Boolean enabled) {
        IosNotificationSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosNotificationSettings");
        _x.enabled = enabled;
        return _x;
    }

    /**
     * <i>“Overrides the notification preview policy set by the user on an iOS device.”</i>
     * 
     * @return property previewVisibility
     */
    @Property(name="previewVisibility")
    @JsonIgnore
    public Optional<IosNotificationPreviewVisibility> getPreviewVisibility() {
        return Optional.ofNullable(previewVisibility);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code previewVisibility
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Overrides the notification preview policy set by the user on an iOS device.”</i>
     * 
     * @param previewVisibility
     *            new value of {@code previewVisibility} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code previewVisibility} field changed
     */
    public IosNotificationSettings withPreviewVisibility(IosNotificationPreviewVisibility previewVisibility) {
        IosNotificationSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosNotificationSettings");
        _x.previewVisibility = previewVisibility;
        return _x;
    }

    /**
     * <i>“Publisher to be associated with the bundleID.”</i>
     * 
     * @return property publisher
     */
    @Property(name="publisher")
    @JsonIgnore
    public Optional<String> getPublisher() {
        return Optional.ofNullable(publisher);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code publisher} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Publisher to be associated with the bundleID.”</i>
     * 
     * @param publisher
     *            new value of {@code publisher} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code publisher} field changed
     */
    public IosNotificationSettings withPublisher(String publisher) {
        IosNotificationSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosNotificationSettings");
        _x.publisher = publisher;
        return _x;
    }

    /**
     * <i>“Indicates whether notifications can be shown in notification center.”</i>
     * 
     * @return property showInNotificationCenter
     */
    @Property(name="showInNotificationCenter")
    @JsonIgnore
    public Optional<Boolean> getShowInNotificationCenter() {
        return Optional.ofNullable(showInNotificationCenter);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * showInNotificationCenter} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether notifications can be shown in notification center.”</i>
     * 
     * @param showInNotificationCenter
     *            new value of {@code showInNotificationCenter} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code showInNotificationCenter} field changed
     */
    public IosNotificationSettings withShowInNotificationCenter(Boolean showInNotificationCenter) {
        IosNotificationSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosNotificationSettings");
        _x.showInNotificationCenter = showInNotificationCenter;
        return _x;
    }

    /**
     * <i>“Indicates whether notifications can be shown on the lock screen.”</i>
     * 
     * @return property showOnLockScreen
     */
    @Property(name="showOnLockScreen")
    @JsonIgnore
    public Optional<Boolean> getShowOnLockScreen() {
        return Optional.ofNullable(showOnLockScreen);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code showOnLockScreen}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether notifications can be shown on the lock screen.”</i>
     * 
     * @param showOnLockScreen
     *            new value of {@code showOnLockScreen} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code showOnLockScreen} field changed
     */
    public IosNotificationSettings withShowOnLockScreen(Boolean showOnLockScreen) {
        IosNotificationSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosNotificationSettings");
        _x.showOnLockScreen = showOnLockScreen;
        return _x;
    }

    /**
     * <i>“Indicates whether sounds are allowed for this app.”</i>
     * 
     * @return property soundsEnabled
     */
    @Property(name="soundsEnabled")
    @JsonIgnore
    public Optional<Boolean> getSoundsEnabled() {
        return Optional.ofNullable(soundsEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code soundsEnabled}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether sounds are allowed for this app.”</i>
     * 
     * @param soundsEnabled
     *            new value of {@code soundsEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code soundsEnabled} field changed
     */
    public IosNotificationSettings withSoundsEnabled(Boolean soundsEnabled) {
        IosNotificationSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosNotificationSettings");
        _x.soundsEnabled = soundsEnabled;
        return _x;
    }

    public IosNotificationSettings withUnmappedField(String name, Object value) {
        IosNotificationSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IosNotificationAlertType alertType;
        private String appName;
        private Boolean badgesEnabled;
        private String bundleID;
        private Boolean enabled;
        private IosNotificationPreviewVisibility previewVisibility;
        private String publisher;
        private Boolean showInNotificationCenter;
        private Boolean showOnLockScreen;
        private Boolean soundsEnabled;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Indicates the type of alert for notifications for this app.”</i>
         * 
         * @param alertType
         *            value of {@code alertType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder alertType(IosNotificationAlertType alertType) {
            this.alertType = alertType;
            this.changedFields = changedFields.add("alertType");
            return this;
        }

        /**
         * <i>“Application name to be associated with the bundleID.”</i>
         * 
         * @param appName
         *            value of {@code appName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appName(String appName) {
            this.appName = appName;
            this.changedFields = changedFields.add("appName");
            return this;
        }

        /**
         * <i>“Indicates whether badges are allowed for this app.”</i>
         * 
         * @param badgesEnabled
         *            value of {@code badgesEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder badgesEnabled(Boolean badgesEnabled) {
            this.badgesEnabled = badgesEnabled;
            this.changedFields = changedFields.add("badgesEnabled");
            return this;
        }

        /**
         * <i>“Bundle id of app to which to apply these notification settings.”</i>
         * 
         * @param bundleID
         *            value of {@code bundleID} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bundleID(String bundleID) {
            this.bundleID = bundleID;
            this.changedFields = changedFields.add("bundleID");
            return this;
        }

        /**
         * <i>“Indicates whether notifications are allowed for this app.”</i>
         * 
         * @param enabled
         *            value of {@code enabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            this.changedFields = changedFields.add("enabled");
            return this;
        }

        /**
         * <i>“Overrides the notification preview policy set by the user on an iOS device.”</i>
         * 
         * @param previewVisibility
         *            value of {@code previewVisibility} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder previewVisibility(IosNotificationPreviewVisibility previewVisibility) {
            this.previewVisibility = previewVisibility;
            this.changedFields = changedFields.add("previewVisibility");
            return this;
        }

        /**
         * <i>“Publisher to be associated with the bundleID.”</i>
         * 
         * @param publisher
         *            value of {@code publisher} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder publisher(String publisher) {
            this.publisher = publisher;
            this.changedFields = changedFields.add("publisher");
            return this;
        }

        /**
         * <i>“Indicates whether notifications can be shown in notification center.”</i>
         * 
         * @param showInNotificationCenter
         *            value of {@code showInNotificationCenter} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder showInNotificationCenter(Boolean showInNotificationCenter) {
            this.showInNotificationCenter = showInNotificationCenter;
            this.changedFields = changedFields.add("showInNotificationCenter");
            return this;
        }

        /**
         * <i>“Indicates whether notifications can be shown on the lock screen.”</i>
         * 
         * @param showOnLockScreen
         *            value of {@code showOnLockScreen} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder showOnLockScreen(Boolean showOnLockScreen) {
            this.showOnLockScreen = showOnLockScreen;
            this.changedFields = changedFields.add("showOnLockScreen");
            return this;
        }

        /**
         * <i>“Indicates whether sounds are allowed for this app.”</i>
         * 
         * @param soundsEnabled
         *            value of {@code soundsEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder soundsEnabled(Boolean soundsEnabled) {
            this.soundsEnabled = soundsEnabled;
            this.changedFields = changedFields.add("soundsEnabled");
            return this;
        }

        public IosNotificationSettings build() {
            IosNotificationSettings _x = new IosNotificationSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.iosNotificationSettings";
            _x.alertType = alertType;
            _x.appName = appName;
            _x.badgesEnabled = badgesEnabled;
            _x.bundleID = bundleID;
            _x.enabled = enabled;
            _x.previewVisibility = previewVisibility;
            _x.publisher = publisher;
            _x.showInNotificationCenter = showInNotificationCenter;
            _x.showOnLockScreen = showOnLockScreen;
            _x.soundsEnabled = soundsEnabled;
            return _x;
        }
    }

    private IosNotificationSettings _copy() {
        IosNotificationSettings _x = new IosNotificationSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.alertType = alertType;
        _x.appName = appName;
        _x.badgesEnabled = badgesEnabled;
        _x.bundleID = bundleID;
        _x.enabled = enabled;
        _x.previewVisibility = previewVisibility;
        _x.publisher = publisher;
        _x.showInNotificationCenter = showInNotificationCenter;
        _x.showOnLockScreen = showOnLockScreen;
        _x.soundsEnabled = soundsEnabled;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosNotificationSettings[");
        b.append("alertType=");
        b.append(this.alertType);
        b.append(", ");
        b.append("appName=");
        b.append(this.appName);
        b.append(", ");
        b.append("badgesEnabled=");
        b.append(this.badgesEnabled);
        b.append(", ");
        b.append("bundleID=");
        b.append(this.bundleID);
        b.append(", ");
        b.append("enabled=");
        b.append(this.enabled);
        b.append(", ");
        b.append("previewVisibility=");
        b.append(this.previewVisibility);
        b.append(", ");
        b.append("publisher=");
        b.append(this.publisher);
        b.append(", ");
        b.append("showInNotificationCenter=");
        b.append(this.showInNotificationCenter);
        b.append(", ");
        b.append("showOnLockScreen=");
        b.append(this.showOnLockScreen);
        b.append(", ");
        b.append("soundsEnabled=");
        b.append(this.soundsEnabled);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
