package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“A page for a folder containing apps and web clips on the Home Screen.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "apps", 
    "displayName"})
@JsonInclude(Include.NON_NULL)
public class IosHomeScreenFolderPage implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("apps")
    protected List<IosHomeScreenApp> apps;

    @JsonProperty("apps@nextLink")
    protected String appsNextLink;

    @JsonProperty("displayName")
    protected String displayName;

    protected IosHomeScreenFolderPage() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosHomeScreenFolderPage";
    }

    /**
     * <i>“A list of apps and web clips to appear on a page within a folder. This
     * collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property apps
     */
    @Property(name="apps")
    @JsonIgnore
    public CollectionPage<IosHomeScreenApp> getApps() {
        return new CollectionPage<IosHomeScreenApp>(contextPath, IosHomeScreenApp.class, this.apps, Optional.ofNullable(appsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“A list of apps and web clips to appear on a page within a folder. This
     * collection can contain a maximum of 500 elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property apps
     */
    @Property(name="apps")
    @JsonIgnore
    public CollectionPage<IosHomeScreenApp> getApps(HttpRequestOptions options) {
        return new CollectionPage<IosHomeScreenApp>(contextPath, IosHomeScreenApp.class, this.apps, Optional.ofNullable(appsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Name of the folder page”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Name of the folder page”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public IosHomeScreenFolderPage withDisplayName(String displayName) {
        IosHomeScreenFolderPage _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosHomeScreenFolderPage");
        _x.displayName = displayName;
        return _x;
    }

    public IosHomeScreenFolderPage withUnmappedField(String name, Object value) {
        IosHomeScreenFolderPage _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<IosHomeScreenApp> apps;
        private String appsNextLink;
        private String displayName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“A list of apps and web clips to appear on a page within a folder. This
         * collection can contain a maximum of 500 elements.”</i>
         * 
         * @param apps
         *            value of {@code apps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder apps(List<IosHomeScreenApp> apps) {
            this.apps = apps;
            this.changedFields = changedFields.add("apps");
            return this;
        }

        /**
         * <i>“A list of apps and web clips to appear on a page within a folder. This
         * collection can contain a maximum of 500 elements.”</i>
         * 
         * @param apps
         *            value of {@code apps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder apps(IosHomeScreenApp... apps) {
            return apps(Arrays.asList(apps));
        }

        /**
         * <i>“A list of apps and web clips to appear on a page within a folder. This
         * collection can contain a maximum of 500 elements.”</i>
         * 
         * @param appsNextLink
         *            value of {@code apps@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appsNextLink(String appsNextLink) {
            this.appsNextLink = appsNextLink;
            this.changedFields = changedFields.add("apps");
            return this;
        }

        /**
         * <i>“Name of the folder page”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public IosHomeScreenFolderPage build() {
            IosHomeScreenFolderPage _x = new IosHomeScreenFolderPage();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.iosHomeScreenFolderPage";
            _x.apps = apps;
            _x.appsNextLink = appsNextLink;
            _x.displayName = displayName;
            return _x;
        }
    }

    private IosHomeScreenFolderPage _copy() {
        IosHomeScreenFolderPage _x = new IosHomeScreenFolderPage();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.apps = apps;
        _x.displayName = displayName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosHomeScreenFolderPage[");
        b.append("apps=");
        b.append(this.apps);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
