package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“A folder containing pages of apps and web clips on the Home Screen.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "pages"})
@JsonInclude(Include.NON_NULL)
public class IosHomeScreenFolder extends IosHomeScreenItem implements ODataType {

    @JsonProperty("pages")
    protected List<IosHomeScreenFolderPage> pages;

    @JsonProperty("pages@nextLink")
    protected String pagesNextLink;

    protected IosHomeScreenFolder() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosHomeScreenFolder";
    }

    /**
     * <i>“Pages of Home Screen Layout Icons which must be applications or web clips. This
     * collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property pages
     */
    @Property(name="pages")
    @JsonIgnore
    public CollectionPage<IosHomeScreenFolderPage> getPages() {
        return new CollectionPage<IosHomeScreenFolderPage>(contextPath, IosHomeScreenFolderPage.class, this.pages, Optional.ofNullable(pagesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Pages of Home Screen Layout Icons which must be applications or web clips. This
     * collection can contain a maximum of 500 elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property pages
     */
    @Property(name="pages")
    @JsonIgnore
    public CollectionPage<IosHomeScreenFolderPage> getPages(HttpRequestOptions options) {
        return new CollectionPage<IosHomeScreenFolderPage>(contextPath, IosHomeScreenFolderPage.class, this.pages, Optional.ofNullable(pagesNextLink), Collections.emptyList(), options);
    }

    public IosHomeScreenFolder withUnmappedField(String name, Object value) {
        IosHomeScreenFolder _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderIosHomeScreenFolder() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private List<IosHomeScreenFolderPage> pages;
        private String pagesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Pages of Home Screen Layout Icons which must be applications or web clips. This
         * collection can contain a maximum of 500 elements.”</i>
         * 
         * @param pages
         *            value of {@code pages} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder pages(List<IosHomeScreenFolderPage> pages) {
            this.pages = pages;
            this.changedFields = changedFields.add("pages");
            return this;
        }

        /**
         * <i>“Pages of Home Screen Layout Icons which must be applications or web clips. This
         * collection can contain a maximum of 500 elements.”</i>
         * 
         * @param pages
         *            value of {@code pages} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder pages(IosHomeScreenFolderPage... pages) {
            return pages(Arrays.asList(pages));
        }

        /**
         * <i>“Pages of Home Screen Layout Icons which must be applications or web clips. This
         * collection can contain a maximum of 500 elements.”</i>
         * 
         * @param pagesNextLink
         *            value of {@code pages@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder pagesNextLink(String pagesNextLink) {
            this.pagesNextLink = pagesNextLink;
            this.changedFields = changedFields.add("pages");
            return this;
        }

        public IosHomeScreenFolder build() {
            IosHomeScreenFolder _x = new IosHomeScreenFolder();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.iosHomeScreenFolder";
            _x.displayName = displayName;
            _x.pages = pages;
            _x.pagesNextLink = pagesNextLink;
            return _x;
        }
    }

    private IosHomeScreenFolder _copy() {
        IosHomeScreenFolder _x = new IosHomeScreenFolder();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.pages = pages;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosHomeScreenFolder[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("pages=");
        b.append(this.pages);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
