package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Represents an icon for an app on the Home Screen”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "bundleID", 
    "isWebClip"})
@JsonInclude(Include.NON_NULL)
public class IosHomeScreenApp extends IosHomeScreenItem implements ODataType {

    @JsonProperty("bundleID")
    protected String bundleID;

    @JsonProperty("isWebClip")
    protected Boolean isWebClip;

    protected IosHomeScreenApp() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosHomeScreenApp";
    }

    /**
     * <i>“BundleID of the app if isWebClip is false or the URL of a web clip if isWebClip
     * is true.”</i>
     * 
     * @return property bundleID
     */
    @Property(name="bundleID")
    @JsonIgnore
    public Optional<String> getBundleID() {
        return Optional.ofNullable(bundleID);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code bundleID} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“BundleID of the app if isWebClip is false or the URL of a web clip if isWebClip
     * is true.”</i>
     * 
     * @param bundleID
     *            new value of {@code bundleID} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bundleID} field changed
     */
    public IosHomeScreenApp withBundleID(String bundleID) {
        IosHomeScreenApp _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosHomeScreenApp");
        _x.bundleID = bundleID;
        return _x;
    }

    /**
     * <i>“When true, the bundle ID will be handled as a URL for a web clip.”</i>
     * 
     * @return property isWebClip
     */
    @Property(name="isWebClip")
    @JsonIgnore
    public Optional<Boolean> getIsWebClip() {
        return Optional.ofNullable(isWebClip);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isWebClip} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“When true, the bundle ID will be handled as a URL for a web clip.”</i>
     * 
     * @param isWebClip
     *            new value of {@code isWebClip} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isWebClip} field changed
     */
    public IosHomeScreenApp withIsWebClip(Boolean isWebClip) {
        IosHomeScreenApp _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosHomeScreenApp");
        _x.isWebClip = isWebClip;
        return _x;
    }

    public IosHomeScreenApp withUnmappedField(String name, Object value) {
        IosHomeScreenApp _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderIosHomeScreenApp() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private String bundleID;
        private Boolean isWebClip;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“BundleID of the app if isWebClip is false or the URL of a web clip if isWebClip
         * is true.”</i>
         * 
         * @param bundleID
         *            value of {@code bundleID} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bundleID(String bundleID) {
            this.bundleID = bundleID;
            this.changedFields = changedFields.add("bundleID");
            return this;
        }

        /**
         * <i>“When true, the bundle ID will be handled as a URL for a web clip.”</i>
         * 
         * @param isWebClip
         *            value of {@code isWebClip} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isWebClip(Boolean isWebClip) {
            this.isWebClip = isWebClip;
            this.changedFields = changedFields.add("isWebClip");
            return this;
        }

        public IosHomeScreenApp build() {
            IosHomeScreenApp _x = new IosHomeScreenApp();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.iosHomeScreenApp";
            _x.displayName = displayName;
            _x.bundleID = bundleID;
            _x.isWebClip = isWebClip;
            return _x;
        }
    }

    private IosHomeScreenApp _copy() {
        IosHomeScreenApp _x = new IosHomeScreenApp();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.bundleID = bundleID;
        _x.isWebClip = isWebClip;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosHomeScreenApp[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("bundleID=");
        b.append(this.bundleID);
        b.append(", ");
        b.append("isWebClip=");
        b.append(this.isWebClip);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
