package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“iOS available update version details”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "expirationDateTime", 
    "postingDateTime", 
    "productVersion", 
    "supportedDevices"})
@JsonInclude(Include.NON_NULL)
public class IosAvailableUpdateVersion implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("expirationDateTime")
    protected OffsetDateTime expirationDateTime;

    @JsonProperty("postingDateTime")
    protected OffsetDateTime postingDateTime;

    @JsonProperty("productVersion")
    protected String productVersion;

    @JsonProperty("supportedDevices")
    protected List<String> supportedDevices;

    @JsonProperty("supportedDevices@nextLink")
    protected String supportedDevicesNextLink;

    protected IosAvailableUpdateVersion() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosAvailableUpdateVersion";
    }

    /**
     * <i>“The expiration date of the update.”</i>
     * 
     * @return property expirationDateTime
     */
    @Property(name="expirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpirationDateTime() {
        return Optional.ofNullable(expirationDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * expirationDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The expiration date of the update.”</i>
     * 
     * @param expirationDateTime
     *            new value of {@code expirationDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code expirationDateTime} field changed
     */
    public IosAvailableUpdateVersion withExpirationDateTime(OffsetDateTime expirationDateTime) {
        IosAvailableUpdateVersion _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosAvailableUpdateVersion");
        _x.expirationDateTime = expirationDateTime;
        return _x;
    }

    /**
     * <i>“The posting date of the update.”</i>
     * 
     * @return property postingDateTime
     */
    @Property(name="postingDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getPostingDateTime() {
        return Optional.ofNullable(postingDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code postingDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The posting date of the update.”</i>
     * 
     * @param postingDateTime
     *            new value of {@code postingDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code postingDateTime} field changed
     */
    public IosAvailableUpdateVersion withPostingDateTime(OffsetDateTime postingDateTime) {
        IosAvailableUpdateVersion _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosAvailableUpdateVersion");
        _x.postingDateTime = postingDateTime;
        return _x;
    }

    /**
     * <i>“The version of the update.”</i>
     * 
     * @return property productVersion
     */
    @Property(name="productVersion")
    @JsonIgnore
    public Optional<String> getProductVersion() {
        return Optional.ofNullable(productVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code productVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The version of the update.”</i>
     * 
     * @param productVersion
     *            new value of {@code productVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code productVersion} field changed
     */
    public IosAvailableUpdateVersion withProductVersion(String productVersion) {
        IosAvailableUpdateVersion _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosAvailableUpdateVersion");
        _x.productVersion = productVersion;
        return _x;
    }

    /**
     * <i>“List of supported devices for the update.”</i>
     * 
     * @return property supportedDevices
     */
    @Property(name="supportedDevices")
    @JsonIgnore
    public CollectionPage<String> getSupportedDevices() {
        return new CollectionPage<String>(contextPath, String.class, this.supportedDevices, Optional.ofNullable(supportedDevicesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of supported devices for the update.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property supportedDevices
     */
    @Property(name="supportedDevices")
    @JsonIgnore
    public CollectionPage<String> getSupportedDevices(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.supportedDevices, Optional.ofNullable(supportedDevicesNextLink), Collections.emptyList(), options);
    }

    public IosAvailableUpdateVersion withUnmappedField(String name, Object value) {
        IosAvailableUpdateVersion _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime expirationDateTime;
        private OffsetDateTime postingDateTime;
        private String productVersion;
        private List<String> supportedDevices;
        private String supportedDevicesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The expiration date of the update.”</i>
         * 
         * @param expirationDateTime
         *            value of {@code expirationDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder expirationDateTime(OffsetDateTime expirationDateTime) {
            this.expirationDateTime = expirationDateTime;
            this.changedFields = changedFields.add("expirationDateTime");
            return this;
        }

        /**
         * <i>“The posting date of the update.”</i>
         * 
         * @param postingDateTime
         *            value of {@code postingDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder postingDateTime(OffsetDateTime postingDateTime) {
            this.postingDateTime = postingDateTime;
            this.changedFields = changedFields.add("postingDateTime");
            return this;
        }

        /**
         * <i>“The version of the update.”</i>
         * 
         * @param productVersion
         *            value of {@code productVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder productVersion(String productVersion) {
            this.productVersion = productVersion;
            this.changedFields = changedFields.add("productVersion");
            return this;
        }

        /**
         * <i>“List of supported devices for the update.”</i>
         * 
         * @param supportedDevices
         *            value of {@code supportedDevices} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder supportedDevices(List<String> supportedDevices) {
            this.supportedDevices = supportedDevices;
            this.changedFields = changedFields.add("supportedDevices");
            return this;
        }

        /**
         * <i>“List of supported devices for the update.”</i>
         * 
         * @param supportedDevices
         *            value of {@code supportedDevices} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder supportedDevices(String... supportedDevices) {
            return supportedDevices(Arrays.asList(supportedDevices));
        }

        /**
         * <i>“List of supported devices for the update.”</i>
         * 
         * @param supportedDevicesNextLink
         *            value of {@code supportedDevices@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder supportedDevicesNextLink(String supportedDevicesNextLink) {
            this.supportedDevicesNextLink = supportedDevicesNextLink;
            this.changedFields = changedFields.add("supportedDevices");
            return this;
        }

        public IosAvailableUpdateVersion build() {
            IosAvailableUpdateVersion _x = new IosAvailableUpdateVersion();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.iosAvailableUpdateVersion";
            _x.expirationDateTime = expirationDateTime;
            _x.postingDateTime = postingDateTime;
            _x.productVersion = productVersion;
            _x.supportedDevices = supportedDevices;
            _x.supportedDevicesNextLink = supportedDevicesNextLink;
            return _x;
        }
    }

    private IosAvailableUpdateVersion _copy() {
        IosAvailableUpdateVersion _x = new IosAvailableUpdateVersion();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.expirationDateTime = expirationDateTime;
        _x.postingDateTime = postingDateTime;
        _x.productVersion = productVersion;
        _x.supportedDevices = supportedDevices;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosAvailableUpdateVersion[");
        b.append("expirationDateTime=");
        b.append(this.expirationDateTime);
        b.append(", ");
        b.append("postingDateTime=");
        b.append(this.postingDateTime);
        b.append(", ");
        b.append("productVersion=");
        b.append(this.productVersion);
        b.append(", ");
        b.append("supportedDevices=");
        b.append(this.supportedDevices);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
