package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "inviteUri"})
@JsonInclude(Include.NON_NULL)
public class InviteNewBotResponse extends ParticipantJoiningResponse implements ODataType {

    @JsonProperty("inviteUri")
    protected String inviteUri;

    protected InviteNewBotResponse() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.inviteNewBotResponse";
    }

    @Property(name="inviteUri")
    @JsonIgnore
    public Optional<String> getInviteUri() {
        return Optional.ofNullable(inviteUri);
    }

    public InviteNewBotResponse withInviteUri(String inviteUri) {
        InviteNewBotResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.inviteNewBotResponse");
        _x.inviteUri = inviteUri;
        return _x;
    }

    public InviteNewBotResponse withUnmappedField(String name, Object value) {
        InviteNewBotResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderInviteNewBotResponse() {
        return new Builder();
    }

    public static final class Builder {
        private String inviteUri;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder inviteUri(String inviteUri) {
            this.inviteUri = inviteUri;
            this.changedFields = changedFields.add("inviteUri");
            return this;
        }

        public InviteNewBotResponse build() {
            InviteNewBotResponse _x = new InviteNewBotResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.inviteNewBotResponse";
            _x.inviteUri = inviteUri;
            return _x;
        }
    }

    private InviteNewBotResponse _copy() {
        InviteNewBotResponse _x = new InviteNewBotResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.inviteUri = inviteUri;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("InviteNewBotResponse[");
        b.append("inviteUri=");
        b.append(this.inviteUri);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
