package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "cidrAddress"})
@JsonInclude(Include.NON_NULL)
public class IPv6CidrRange extends IpRange implements ODataType {

    @JsonProperty("cidrAddress")
    protected String cidrAddress;

    protected IPv6CidrRange() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iPv6CidrRange";
    }

    @Property(name="cidrAddress")
    @JsonIgnore
    public Optional<String> getCidrAddress() {
        return Optional.ofNullable(cidrAddress);
    }

    public IPv6CidrRange withCidrAddress(String cidrAddress) {
        IPv6CidrRange _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iPv6CidrRange");
        _x.cidrAddress = cidrAddress;
        return _x;
    }

    public IPv6CidrRange withUnmappedField(String name, Object value) {
        IPv6CidrRange _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderIPv6CidrRange() {
        return new Builder();
    }

    public static final class Builder {
        private String cidrAddress;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder cidrAddress(String cidrAddress) {
            this.cidrAddress = cidrAddress;
            this.changedFields = changedFields.add("cidrAddress");
            return this;
        }

        public IPv6CidrRange build() {
            IPv6CidrRange _x = new IPv6CidrRange();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.iPv6CidrRange";
            _x.cidrAddress = cidrAddress;
            return _x;
        }
    }

    private IPv6CidrRange _copy() {
        IPv6CidrRange _x = new IPv6CidrRange();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.cidrAddress = cidrAddress;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IPv6CidrRange[");
        b.append("cidrAddress=");
        b.append(this.cidrAddress);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
