package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "isPicture"})
@JsonInclude(Include.NON_NULL)
public class HyperlinkOrPictureColumn implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("isPicture")
    protected Boolean isPicture;

    protected HyperlinkOrPictureColumn() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.hyperlinkOrPictureColumn";
    }

    @Property(name="isPicture")
    @JsonIgnore
    public Optional<Boolean> getIsPicture() {
        return Optional.ofNullable(isPicture);
    }

    public HyperlinkOrPictureColumn withIsPicture(Boolean isPicture) {
        HyperlinkOrPictureColumn _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hyperlinkOrPictureColumn");
        _x.isPicture = isPicture;
        return _x;
    }

    public HyperlinkOrPictureColumn withUnmappedField(String name, Object value) {
        HyperlinkOrPictureColumn _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isPicture;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder isPicture(Boolean isPicture) {
            this.isPicture = isPicture;
            this.changedFields = changedFields.add("isPicture");
            return this;
        }

        public HyperlinkOrPictureColumn build() {
            HyperlinkOrPictureColumn _x = new HyperlinkOrPictureColumn();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.hyperlinkOrPictureColumn";
            _x.isPicture = isPicture;
            return _x;
        }
    }

    private HyperlinkOrPictureColumn _copy() {
        HyperlinkOrPictureColumn _x = new HyperlinkOrPictureColumn();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.isPicture = isPicture;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("HyperlinkOrPictureColumn[");
        b.append("isPicture=");
        b.append(this.isPicture);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
