package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "allowUpdateConfigurationOverride", 
    "deferUpdateDateTime", 
    "updateWindow"})
@JsonInclude(Include.NON_NULL)
public class HybridAgentUpdaterConfiguration implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("allowUpdateConfigurationOverride")
    protected Boolean allowUpdateConfigurationOverride;

    @JsonProperty("deferUpdateDateTime")
    protected OffsetDateTime deferUpdateDateTime;

    @JsonProperty("updateWindow")
    protected UpdateWindow updateWindow;

    protected HybridAgentUpdaterConfiguration() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.hybridAgentUpdaterConfiguration";
    }

    @Property(name="allowUpdateConfigurationOverride")
    @JsonIgnore
    public Optional<Boolean> getAllowUpdateConfigurationOverride() {
        return Optional.ofNullable(allowUpdateConfigurationOverride);
    }

    public HybridAgentUpdaterConfiguration withAllowUpdateConfigurationOverride(Boolean allowUpdateConfigurationOverride) {
        HybridAgentUpdaterConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hybridAgentUpdaterConfiguration");
        _x.allowUpdateConfigurationOverride = allowUpdateConfigurationOverride;
        return _x;
    }

    @Property(name="deferUpdateDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getDeferUpdateDateTime() {
        return Optional.ofNullable(deferUpdateDateTime);
    }

    public HybridAgentUpdaterConfiguration withDeferUpdateDateTime(OffsetDateTime deferUpdateDateTime) {
        HybridAgentUpdaterConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hybridAgentUpdaterConfiguration");
        _x.deferUpdateDateTime = deferUpdateDateTime;
        return _x;
    }

    @Property(name="updateWindow")
    @JsonIgnore
    public Optional<UpdateWindow> getUpdateWindow() {
        return Optional.ofNullable(updateWindow);
    }

    public HybridAgentUpdaterConfiguration withUpdateWindow(UpdateWindow updateWindow) {
        HybridAgentUpdaterConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hybridAgentUpdaterConfiguration");
        _x.updateWindow = updateWindow;
        return _x;
    }

    public HybridAgentUpdaterConfiguration withUnmappedField(String name, Object value) {
        HybridAgentUpdaterConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean allowUpdateConfigurationOverride;
        private OffsetDateTime deferUpdateDateTime;
        private UpdateWindow updateWindow;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder allowUpdateConfigurationOverride(Boolean allowUpdateConfigurationOverride) {
            this.allowUpdateConfigurationOverride = allowUpdateConfigurationOverride;
            this.changedFields = changedFields.add("allowUpdateConfigurationOverride");
            return this;
        }

        public Builder deferUpdateDateTime(OffsetDateTime deferUpdateDateTime) {
            this.deferUpdateDateTime = deferUpdateDateTime;
            this.changedFields = changedFields.add("deferUpdateDateTime");
            return this;
        }

        public Builder updateWindow(UpdateWindow updateWindow) {
            this.updateWindow = updateWindow;
            this.changedFields = changedFields.add("updateWindow");
            return this;
        }

        public HybridAgentUpdaterConfiguration build() {
            HybridAgentUpdaterConfiguration _x = new HybridAgentUpdaterConfiguration();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.hybridAgentUpdaterConfiguration";
            _x.allowUpdateConfigurationOverride = allowUpdateConfigurationOverride;
            _x.deferUpdateDateTime = deferUpdateDateTime;
            _x.updateWindow = updateWindow;
            return _x;
        }
    }

    private HybridAgentUpdaterConfiguration _copy() {
        HybridAgentUpdaterConfiguration _x = new HybridAgentUpdaterConfiguration();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.allowUpdateConfigurationOverride = allowUpdateConfigurationOverride;
        _x.deferUpdateDateTime = deferUpdateDateTime;
        _x.updateWindow = updateWindow;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("HybridAgentUpdaterConfiguration[");
        b.append("allowUpdateConfigurationOverride=");
        b.append(this.allowUpdateConfigurationOverride);
        b.append(", ");
        b.append("deferUpdateDateTime=");
        b.append(this.deferUpdateDateTime);
        b.append(", ");
        b.append("updateWindow=");
        b.append(this.updateWindow);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
