package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "completedJobCount", 
    "group", 
    "groupDisplayName", 
    "groupMail", 
    "incompleteJobCount"})
@JsonInclude(Include.NON_NULL)
public class GroupPrintUsageSummary implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("completedJobCount")
    protected Integer completedJobCount;

    @JsonProperty("group")
    protected Identity group;

    @JsonProperty("groupDisplayName")
    protected String groupDisplayName;

    @JsonProperty("groupMail")
    protected String groupMail;

    @JsonProperty("incompleteJobCount")
    protected Integer incompleteJobCount;

    protected GroupPrintUsageSummary() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.groupPrintUsageSummary";
    }

    @Property(name="completedJobCount")
    @JsonIgnore
    public Optional<Integer> getCompletedJobCount() {
        return Optional.ofNullable(completedJobCount);
    }

    public GroupPrintUsageSummary withCompletedJobCount(Integer completedJobCount) {
        GroupPrintUsageSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPrintUsageSummary");
        _x.completedJobCount = completedJobCount;
        return _x;
    }

    @Property(name="group")
    @JsonIgnore
    public Optional<Identity> getGroup() {
        return Optional.ofNullable(group);
    }

    public GroupPrintUsageSummary withGroup(Identity group) {
        GroupPrintUsageSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPrintUsageSummary");
        _x.group = group;
        return _x;
    }

    @Property(name="groupDisplayName")
    @JsonIgnore
    public Optional<String> getGroupDisplayName() {
        return Optional.ofNullable(groupDisplayName);
    }

    public GroupPrintUsageSummary withGroupDisplayName(String groupDisplayName) {
        GroupPrintUsageSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPrintUsageSummary");
        _x.groupDisplayName = groupDisplayName;
        return _x;
    }

    @Property(name="groupMail")
    @JsonIgnore
    public Optional<String> getGroupMail() {
        return Optional.ofNullable(groupMail);
    }

    public GroupPrintUsageSummary withGroupMail(String groupMail) {
        GroupPrintUsageSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPrintUsageSummary");
        _x.groupMail = groupMail;
        return _x;
    }

    @Property(name="incompleteJobCount")
    @JsonIgnore
    public Optional<Integer> getIncompleteJobCount() {
        return Optional.ofNullable(incompleteJobCount);
    }

    public GroupPrintUsageSummary withIncompleteJobCount(Integer incompleteJobCount) {
        GroupPrintUsageSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPrintUsageSummary");
        _x.incompleteJobCount = incompleteJobCount;
        return _x;
    }

    public GroupPrintUsageSummary withUnmappedField(String name, Object value) {
        GroupPrintUsageSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer completedJobCount;
        private Identity group;
        private String groupDisplayName;
        private String groupMail;
        private Integer incompleteJobCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder completedJobCount(Integer completedJobCount) {
            this.completedJobCount = completedJobCount;
            this.changedFields = changedFields.add("completedJobCount");
            return this;
        }

        public Builder group(Identity group) {
            this.group = group;
            this.changedFields = changedFields.add("group");
            return this;
        }

        public Builder groupDisplayName(String groupDisplayName) {
            this.groupDisplayName = groupDisplayName;
            this.changedFields = changedFields.add("groupDisplayName");
            return this;
        }

        public Builder groupMail(String groupMail) {
            this.groupMail = groupMail;
            this.changedFields = changedFields.add("groupMail");
            return this;
        }

        public Builder incompleteJobCount(Integer incompleteJobCount) {
            this.incompleteJobCount = incompleteJobCount;
            this.changedFields = changedFields.add("incompleteJobCount");
            return this;
        }

        public GroupPrintUsageSummary build() {
            GroupPrintUsageSummary _x = new GroupPrintUsageSummary();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.groupPrintUsageSummary";
            _x.completedJobCount = completedJobCount;
            _x.group = group;
            _x.groupDisplayName = groupDisplayName;
            _x.groupMail = groupMail;
            _x.incompleteJobCount = incompleteJobCount;
            return _x;
        }
    }

    private GroupPrintUsageSummary _copy() {
        GroupPrintUsageSummary _x = new GroupPrintUsageSummary();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.completedJobCount = completedJobCount;
        _x.group = group;
        _x.groupDisplayName = groupDisplayName;
        _x.groupMail = groupMail;
        _x.incompleteJobCount = incompleteJobCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GroupPrintUsageSummary[");
        b.append("completedJobCount=");
        b.append(this.completedJobCount);
        b.append(", ");
        b.append("group=");
        b.append(this.group);
        b.append(", ");
        b.append("groupDisplayName=");
        b.append(this.groupDisplayName);
        b.append(", ");
        b.append("groupMail=");
        b.append(this.groupMail);
        b.append(", ");
        b.append("incompleteJobCount=");
        b.append(this.incompleteJobCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
