package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "id"})
@JsonInclude(Include.NON_NULL)
public class GroupMembers extends UserSet implements ODataType {

    @JsonProperty("description")
    protected String description;

    @JsonProperty("id")
    protected String id;

    protected GroupMembers() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.groupMembers";
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public GroupMembers withDescription(String description) {
        GroupMembers _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupMembers");
        _x.description = description;
        return _x;
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public GroupMembers withId(String id) {
        GroupMembers _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupMembers");
        _x.id = id;
        return _x;
    }

    public GroupMembers withUnmappedField(String name, Object value) {
        GroupMembers _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGroupMembers() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isBackup;
        private String description;
        private String id;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder isBackup(Boolean isBackup) {
            this.isBackup = isBackup;
            this.changedFields = changedFields.add("isBackup");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public GroupMembers build() {
            GroupMembers _x = new GroupMembers();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.groupMembers";
            _x.isBackup = isBackup;
            _x.description = description;
            _x.id = id;
            return _x;
        }
    }

    private GroupMembers _copy() {
        GroupMembers _x = new GroupMembers();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.isBackup = isBackup;
        _x.description = description;
        _x.id = id;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GroupMembers[");
        b.append("isBackup=");
        b.append(this.isBackup);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("id=");
        b.append(this.id);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
