package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "duration", 
    "endDateTime", 
    "startDateTime", 
    "type"})
@JsonInclude(Include.NON_NULL)
public class GovernanceSchedule implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("duration")
    protected Duration duration;

    @JsonProperty("endDateTime")
    protected OffsetDateTime endDateTime;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("type")
    protected String type;

    protected GovernanceSchedule() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.governanceSchedule";
    }

    @Property(name="duration")
    @JsonIgnore
    public Optional<Duration> getDuration() {
        return Optional.ofNullable(duration);
    }

    public GovernanceSchedule withDuration(Duration duration) {
        GovernanceSchedule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceSchedule");
        _x.duration = duration;
        return _x;
    }

    @Property(name="endDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDateTime() {
        return Optional.ofNullable(endDateTime);
    }

    public GovernanceSchedule withEndDateTime(OffsetDateTime endDateTime) {
        GovernanceSchedule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceSchedule");
        _x.endDateTime = endDateTime;
        return _x;
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public GovernanceSchedule withStartDateTime(OffsetDateTime startDateTime) {
        GovernanceSchedule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceSchedule");
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    public GovernanceSchedule withType(String type) {
        GovernanceSchedule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceSchedule");
        _x.type = type;
        return _x;
    }

    public GovernanceSchedule withUnmappedField(String name, Object value) {
        GovernanceSchedule _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Duration duration;
        private OffsetDateTime endDateTime;
        private OffsetDateTime startDateTime;
        private String type;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder duration(Duration duration) {
            this.duration = duration;
            this.changedFields = changedFields.add("duration");
            return this;
        }

        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public GovernanceSchedule build() {
            GovernanceSchedule _x = new GovernanceSchedule();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.governanceSchedule";
            _x.duration = duration;
            _x.endDateTime = endDateTime;
            _x.startDateTime = startDateTime;
            _x.type = type;
            return _x;
        }
    }

    private GovernanceSchedule _copy() {
        GovernanceSchedule _x = new GovernanceSchedule();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.duration = duration;
        _x.endDateTime = endDateTime;
        _x.startDateTime = startDateTime;
        _x.type = type;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GovernanceSchedule[");
        b.append("duration=");
        b.append(this.duration);
        b.append(", ");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
