package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "status", 
    "statusDetails", 
    "subStatus"})
@JsonInclude(Include.NON_NULL)
public class GovernanceRoleAssignmentRequestStatus implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("status")
    protected String status;

    @JsonProperty("statusDetails")
    protected List<KeyValue> statusDetails;

    @JsonProperty("statusDetails@nextLink")
    protected String statusDetailsNextLink;

    @JsonProperty("subStatus")
    protected String subStatus;

    protected GovernanceRoleAssignmentRequestStatus() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.governanceRoleAssignmentRequestStatus";
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    public GovernanceRoleAssignmentRequestStatus withStatus(String status) {
        GovernanceRoleAssignmentRequestStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleAssignmentRequestStatus");
        _x.status = status;
        return _x;
    }

    @Property(name="statusDetails")
    @JsonIgnore
    public CollectionPage<KeyValue> getStatusDetails() {
        return new CollectionPage<KeyValue>(contextPath, KeyValue.class, this.statusDetails, Optional.ofNullable(statusDetailsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="statusDetails")
    @JsonIgnore
    public CollectionPage<KeyValue> getStatusDetails(HttpRequestOptions options) {
        return new CollectionPage<KeyValue>(contextPath, KeyValue.class, this.statusDetails, Optional.ofNullable(statusDetailsNextLink), Collections.emptyList(), options);
    }

    @Property(name="subStatus")
    @JsonIgnore
    public Optional<String> getSubStatus() {
        return Optional.ofNullable(subStatus);
    }

    public GovernanceRoleAssignmentRequestStatus withSubStatus(String subStatus) {
        GovernanceRoleAssignmentRequestStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleAssignmentRequestStatus");
        _x.subStatus = subStatus;
        return _x;
    }

    public GovernanceRoleAssignmentRequestStatus withUnmappedField(String name, Object value) {
        GovernanceRoleAssignmentRequestStatus _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String status;
        private List<KeyValue> statusDetails;
        private String statusDetailsNextLink;
        private String subStatus;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder statusDetails(List<KeyValue> statusDetails) {
            this.statusDetails = statusDetails;
            this.changedFields = changedFields.add("statusDetails");
            return this;
        }

        public Builder statusDetails(KeyValue... statusDetails) {
            return statusDetails(Arrays.asList(statusDetails));
        }

        public Builder statusDetailsNextLink(String statusDetailsNextLink) {
            this.statusDetailsNextLink = statusDetailsNextLink;
            this.changedFields = changedFields.add("statusDetails");
            return this;
        }

        public Builder subStatus(String subStatus) {
            this.subStatus = subStatus;
            this.changedFields = changedFields.add("subStatus");
            return this;
        }

        public GovernanceRoleAssignmentRequestStatus build() {
            GovernanceRoleAssignmentRequestStatus _x = new GovernanceRoleAssignmentRequestStatus();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.governanceRoleAssignmentRequestStatus";
            _x.status = status;
            _x.statusDetails = statusDetails;
            _x.statusDetailsNextLink = statusDetailsNextLink;
            _x.subStatus = subStatus;
            return _x;
        }
    }

    private GovernanceRoleAssignmentRequestStatus _copy() {
        GovernanceRoleAssignmentRequestStatus _x = new GovernanceRoleAssignmentRequestStatus();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.status = status;
        _x.statusDetails = statusDetails;
        _x.subStatus = subStatus;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GovernanceRoleAssignmentRequestStatus[");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("statusDetails=");
        b.append(this.statusDetails);
        b.append(", ");
        b.append("subStatus=");
        b.append(this.subStatus);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
