package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "decisionMakerCriteria", 
    "notificationPolicy"})
@JsonInclude(Include.NON_NULL)
public class GovernancePolicy implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("decisionMakerCriteria")
    protected List<GovernanceCriteria> decisionMakerCriteria;

    @JsonProperty("decisionMakerCriteria@nextLink")
    protected String decisionMakerCriteriaNextLink;

    @JsonProperty("notificationPolicy")
    protected GovernanceNotificationPolicy notificationPolicy;

    protected GovernancePolicy() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.governancePolicy";
    }

    @Property(name="decisionMakerCriteria")
    @JsonIgnore
    public CollectionPage<GovernanceCriteria> getDecisionMakerCriteria() {
        return new CollectionPage<GovernanceCriteria>(contextPath, GovernanceCriteria.class, this.decisionMakerCriteria, Optional.ofNullable(decisionMakerCriteriaNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="decisionMakerCriteria")
    @JsonIgnore
    public CollectionPage<GovernanceCriteria> getDecisionMakerCriteria(HttpRequestOptions options) {
        return new CollectionPage<GovernanceCriteria>(contextPath, GovernanceCriteria.class, this.decisionMakerCriteria, Optional.ofNullable(decisionMakerCriteriaNextLink), Collections.emptyList(), options);
    }

    @Property(name="notificationPolicy")
    @JsonIgnore
    public Optional<GovernanceNotificationPolicy> getNotificationPolicy() {
        return Optional.ofNullable(notificationPolicy);
    }

    public GovernancePolicy withNotificationPolicy(GovernanceNotificationPolicy notificationPolicy) {
        GovernancePolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governancePolicy");
        _x.notificationPolicy = notificationPolicy;
        return _x;
    }

    public GovernancePolicy withUnmappedField(String name, Object value) {
        GovernancePolicy _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<GovernanceCriteria> decisionMakerCriteria;
        private String decisionMakerCriteriaNextLink;
        private GovernanceNotificationPolicy notificationPolicy;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder decisionMakerCriteria(List<GovernanceCriteria> decisionMakerCriteria) {
            this.decisionMakerCriteria = decisionMakerCriteria;
            this.changedFields = changedFields.add("decisionMakerCriteria");
            return this;
        }

        public Builder decisionMakerCriteria(GovernanceCriteria... decisionMakerCriteria) {
            return decisionMakerCriteria(Arrays.asList(decisionMakerCriteria));
        }

        public Builder decisionMakerCriteriaNextLink(String decisionMakerCriteriaNextLink) {
            this.decisionMakerCriteriaNextLink = decisionMakerCriteriaNextLink;
            this.changedFields = changedFields.add("decisionMakerCriteria");
            return this;
        }

        public Builder notificationPolicy(GovernanceNotificationPolicy notificationPolicy) {
            this.notificationPolicy = notificationPolicy;
            this.changedFields = changedFields.add("notificationPolicy");
            return this;
        }

        public GovernancePolicy build() {
            GovernancePolicy _x = new GovernancePolicy();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.governancePolicy";
            _x.decisionMakerCriteria = decisionMakerCriteria;
            _x.decisionMakerCriteriaNextLink = decisionMakerCriteriaNextLink;
            _x.notificationPolicy = notificationPolicy;
            return _x;
        }
    }

    private GovernancePolicy _copy() {
        GovernancePolicy _x = new GovernancePolicy();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.decisionMakerCriteria = decisionMakerCriteria;
        _x.notificationPolicy = notificationPolicy;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GovernancePolicy[");
        b.append("decisionMakerCriteria=");
        b.append(this.decisionMakerCriteria);
        b.append(", ");
        b.append("notificationPolicy=");
        b.append(this.notificationPolicy);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
