package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "enabledTemplateTypes", 
    "notificationTemplates"})
@JsonInclude(Include.NON_NULL)
public class GovernanceNotificationPolicy implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("enabledTemplateTypes")
    protected List<String> enabledTemplateTypes;

    @JsonProperty("enabledTemplateTypes@nextLink")
    protected String enabledTemplateTypesNextLink;

    @JsonProperty("notificationTemplates")
    protected List<GovernanceNotificationTemplate> notificationTemplates;

    @JsonProperty("notificationTemplates@nextLink")
    protected String notificationTemplatesNextLink;

    protected GovernanceNotificationPolicy() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.governanceNotificationPolicy";
    }

    @Property(name="enabledTemplateTypes")
    @JsonIgnore
    public CollectionPage<String> getEnabledTemplateTypes() {
        return new CollectionPage<String>(contextPath, String.class, this.enabledTemplateTypes, Optional.ofNullable(enabledTemplateTypesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="enabledTemplateTypes")
    @JsonIgnore
    public CollectionPage<String> getEnabledTemplateTypes(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.enabledTemplateTypes, Optional.ofNullable(enabledTemplateTypesNextLink), Collections.emptyList(), options);
    }

    @Property(name="notificationTemplates")
    @JsonIgnore
    public CollectionPage<GovernanceNotificationTemplate> getNotificationTemplates() {
        return new CollectionPage<GovernanceNotificationTemplate>(contextPath, GovernanceNotificationTemplate.class, this.notificationTemplates, Optional.ofNullable(notificationTemplatesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="notificationTemplates")
    @JsonIgnore
    public CollectionPage<GovernanceNotificationTemplate> getNotificationTemplates(HttpRequestOptions options) {
        return new CollectionPage<GovernanceNotificationTemplate>(contextPath, GovernanceNotificationTemplate.class, this.notificationTemplates, Optional.ofNullable(notificationTemplatesNextLink), Collections.emptyList(), options);
    }

    public GovernanceNotificationPolicy withUnmappedField(String name, Object value) {
        GovernanceNotificationPolicy _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> enabledTemplateTypes;
        private String enabledTemplateTypesNextLink;
        private List<GovernanceNotificationTemplate> notificationTemplates;
        private String notificationTemplatesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder enabledTemplateTypes(List<String> enabledTemplateTypes) {
            this.enabledTemplateTypes = enabledTemplateTypes;
            this.changedFields = changedFields.add("enabledTemplateTypes");
            return this;
        }

        public Builder enabledTemplateTypes(String... enabledTemplateTypes) {
            return enabledTemplateTypes(Arrays.asList(enabledTemplateTypes));
        }

        public Builder enabledTemplateTypesNextLink(String enabledTemplateTypesNextLink) {
            this.enabledTemplateTypesNextLink = enabledTemplateTypesNextLink;
            this.changedFields = changedFields.add("enabledTemplateTypes");
            return this;
        }

        public Builder notificationTemplates(List<GovernanceNotificationTemplate> notificationTemplates) {
            this.notificationTemplates = notificationTemplates;
            this.changedFields = changedFields.add("notificationTemplates");
            return this;
        }

        public Builder notificationTemplates(GovernanceNotificationTemplate... notificationTemplates) {
            return notificationTemplates(Arrays.asList(notificationTemplates));
        }

        public Builder notificationTemplatesNextLink(String notificationTemplatesNextLink) {
            this.notificationTemplatesNextLink = notificationTemplatesNextLink;
            this.changedFields = changedFields.add("notificationTemplates");
            return this;
        }

        public GovernanceNotificationPolicy build() {
            GovernanceNotificationPolicy _x = new GovernanceNotificationPolicy();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.governanceNotificationPolicy";
            _x.enabledTemplateTypes = enabledTemplateTypes;
            _x.enabledTemplateTypesNextLink = enabledTemplateTypesNextLink;
            _x.notificationTemplates = notificationTemplates;
            _x.notificationTemplatesNextLink = notificationTemplatesNextLink;
            return _x;
        }
    }

    private GovernanceNotificationPolicy _copy() {
        GovernanceNotificationPolicy _x = new GovernanceNotificationPolicy();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.enabledTemplateTypes = enabledTemplateTypes;
        _x.notificationTemplates = notificationTemplates;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GovernanceNotificationPolicy[");
        b.append("enabledTemplateTypes=");
        b.append(this.enabledTemplateTypes);
        b.append(", ");
        b.append("notificationTemplates=");
        b.append(this.notificationTemplates);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
